package io.aether.api.common;
import java.net.URI;
import java.net.URISyntaxException;
import io.aether.net.fastMeta.FastMetaType;
import java.util.UUID;
import java.util.Date;
import io.aether.net.fastMeta.BytesConverter;
import java.io.Closeable;
import io.aether.net.fastMeta.*;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataInOut;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.bytes.ByteSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import java.lang.annotation.*;
import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;
import java.util.*;
public class SodiumSignPrivate extends KeySignPrivate implements io.aether.utils.ToString  {
    @Override public int getAetherTypeId() {
        return 9;
        
    }
    public static final FastMetaType<SodiumSignPrivate> META_BODY = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_92, SodiumSignPrivate obj_93, DataOut out_94) {
            if(obj_93.data.length!=64) throw new java.lang.IllegalArgumentException("Array length is bad for obj_93.data=="+obj_93.data.length+" but must be 64");
            out_94.write(obj_93.data);
            
        }
        @Override public SodiumSignPrivate deserialize(FastFutureContext serializeContextVar_92, DataIn in_95) {
            byte[] data_96;
            var arraySize_97=64;
            data_96=new byte[arraySize_97];
            in_95.read(data_96);
            return new SodiumSignPrivate(data_96);
            
        }
        
    };
    public static final FastMetaType<SodiumSignPrivate> META = new FastMetaType<>() {
        @Override public void serialize(FastFutureContext serializeContextVar_98, SodiumSignPrivate obj_99, DataOut out_100) {
            SodiumSignPrivate.META_BODY.serialize(serializeContextVar_98, obj_99, out_100);
            
        }
        @Override public SodiumSignPrivate deserialize(FastFutureContext serializeContextVar_98, DataIn in_101) {
            return SodiumSignPrivate.META_BODY.deserialize(serializeContextVar_98, in_101);
            
        }
        
    };
    protected final @L(64) byte[] data;
    public SodiumSignPrivate(@L(64) byte[] data)  {
        if (data == null)  {
            throw new java.lang.NullPointerException("Field 'data' cannot be null.");
            
        }
        if (data.length != 64)  {
            throw new java.lang.IllegalArgumentException("Array length for field 'data' must be 64 but was " + data.length);
            
        }
        this.data = data;
        
    }
    public @L(64) byte[] getData()  {
        return this.data;
        
    }
    public boolean dataContains(byte el)  {
        return ByteSet.of(this.data).contains(el);
        
    }
    @Override public boolean equals(Object o)  {
        if (this == o) return true;
        if (o == null || !(o instanceof SodiumSignPrivate)) return false;
        SodiumSignPrivate that = (SodiumSignPrivate) o;
        return java.util.Arrays.equals(this.data, that.data);
        
    }
    @Override public int hashCode()  {
        return java.util.Objects.hash(java.util.Arrays.hashCode(this.data));
        
    }
    @Override public void toString(io.aether.utils.AString sb)  {
        sb.add("SodiumSignPrivate(");
        sb.add("data:");
        sb.add(this.data);
        sb.add(')');
        
    }
    
}