package io.aether.common;

import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.slots.EventConsumer;
import io.aether.utils.rcollections.RCol;
import io.aether.utils.rcollections.RSet;
import it.unimi.dsi.fastutil.longs.LongArrayList;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class AccessGroupListMutable {
    public final RSet<AccessGroupMutable> groups = RCol.set();
    private final EventConsumer<AccessGroupListMutable> onChange = new EventConsumer<>();
    private final AConsumer<UUID> onChangeListener = c -> onChange.fire(this);

    public AccessGroupListMutable() {
        groups.forRemove().add(a -> {
            a.getGroup().forAdd().remove(onChangeListener);
            a.getGroup().forRemove().remove(onChangeListener);
            onChange.fire(this);
        });
        groups.forAdd().add(a -> {
            a.getGroup().forAdd().add(onChangeListener);
            a.getGroup().forRemove().add(onChangeListener);
            onChange.fire(this);
        });
    }

    public void add(AccessGroupMutable ag) {
        groups.add(ag);
    }

    public boolean contains(UUID uid) {
        for (var g : groups) {
            if (g.contains(uid)) return true;
        }
        return false;
    }

    public AFuture containsFuture(UUID uid) {
        if (contains(uid)) return AFuture.completed();
        AFuture res = AFuture.make();
        AConsumer<AccessGroupListMutable> l = a -> {
            if (contains(uid)) {
                res.tryDone();
            }
        };
        res.addListener(f -> onChange.remove(l));
        onChange.add(l);
        return res;
    }

    public UUID[] allAsArray() {
        return all().toArray(new UUID[0]);
    }

    public long[] allGroupIdsAsArray() {
        LongArrayList l = new LongArrayList();
        for (var g : groups) {
            l.add(g.getId());
        }
        return l.toLongArray();
    }

    public Set<UUID> all() {
        var res = new HashSet<UUID>();
        for (var g : groups) {
            res.addAll(g.getGroup());
        }
        return res;
    }

    public boolean remove(AccessGroupMutable gg) {
        return groups.removeIf(g -> g.id == gg.id);
    }
    public boolean remove(long id) {
        return groups.removeIf(g -> g.id == id);
    }
}
