package io.aether.common;

import io.aether.api.common.AccessGroup;
import io.aether.utils.rcollections.RCol;
import io.aether.utils.rcollections.RSet;

import java.util.Arrays;
import java.util.UUID;

public class AccessGroupMutable {
    final long id;
    volatile UUID owner;
    final RSet<UUID> group = RCol.set();
    public AccessGroup toDTO(){
        return new AccessGroup(getOwner(),getId(),getGroup().toArray(new UUID[0]));
    }
    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public long getId() {
        return id;
    }

    public UUID getOwner() {
        return owner;
    }

    public RSet<UUID> getGroup() {
        return group;
    }

    public AccessGroupMutable(AccessGroup a) {
        this.id=a.getId();
        this.owner=a.getOwner();
        this.group.addAll(Arrays.asList(a.getData()));
    }
    public AccessGroupMutable(long id, UUID owner) {
        this.id = id;
        this.owner = owner;
    }

    public boolean add(UUID uid) {
        return group.add(uid);
    }

    public boolean remove(UUID uid) {
        return group.remove(uid);
    }

    public boolean contains(UUID uid) {
        return group.contains(uid);
    }

    public void addAll(UUID[] uuids) {
        for(var u:uuids){
            add(u);
        }
    }

    public void removeAll(UUID[] uuids) {
        for(var u:uuids){
            remove(u);
        }
    }
}
