package io.aether.crypto;

import io.aether.utils.HexUtils;
import io.aether.utils.RU;

public interface AKey extends CryptoProviderUnit{
    byte[] getData();

    KeyType getKeyType();

    int size();

    default SignedKey toSignedKey(Signer signer) {
        return new SignedKey(this, signer.sign(getData()));
    }
    default SignedKey toSignedKey(Sign sign) {
        return new SignedKey(this, sign);
    }

    default String keyToString() {
        return getProviderName() + ":" + getKeyType() + ":" + HexUtils.toHexString(getData());
    }

    default AKey.Symmetric asSymmetric(){
        return (AKey.Symmetric)this;
    }
    default AKey.AsymmetricPublic asAsymmetric(){
        return (AKey.AsymmetricPublic)this;
    }
    default AKey.SignPublic asSignPublic(){
        return (AKey.SignPublic)this;
    }
    default AKey.SignPrivate asSignPrivate(){
        return (AKey.SignPrivate)this;
    }

    static <T extends AKey> T of(String v) {
        return RU.cast(CryptoProviderFactory.createKey(v));
    }

    // Дочерние интерфейсы AKey без методов шифрования/дешифрования
    interface Symmetric extends AKey {
        CryptoEngine toCryptoEngine();
    }

    interface AsymmetricPublic extends AKey {
        CryptoEngine toCryptoEngine();
    }

    interface AsymmetricPrivate extends AKey {
    }

    interface SignPublic extends AKey {
        SignChecker toSignChecker();
    }

    interface SignPrivate extends AKey {
    }
}