package io.aether.crypto;

import io.aether.utils.AString;

public class PairSignKeys implements PairKeys{
    public final AKey.SignPublic publicKey;
    public final AKey.SignPrivate privateKey;
    public Signer toSigner(){
        return getCryptoProvider().createSigner(this);
    }
    @Override
    public String getProviderName() {
        return publicKey.getProviderName();
    }

    @Override
    public void toString(AString sb) {
        sb.add(publicKey.getProviderName());
        sb.add(":");
        publicKey.toString(sb);
        sb.add(":");
        publicKey.toString(sb);
    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public CryptoProvider getCryptoProvider() {
        return publicKey.getCryptoProvider();
    }

    public PairSignKeys(AKey.SignPublic publicKey, AKey.SignPrivate privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public AKey.SignPublic getPublicKey() {
        return publicKey;
    }

    public AKey.SignPrivate getPrivateKey() {
        return privateKey;
    }

    public static PairSignKeys of(String t) {
        var i = t.indexOf(":");
        var cp = CryptoProviderFactory.getProvider(t.substring(0, i));
        return cp.createSignKeys(t.substring(i + 1));
    }
}