package io.aether.utils;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;

public class WorkProofUtil {
	//	private final static BCrypt.Hasher bcrypt = BCrypt.with(BCrypt.Version.VERSION_2A);
//	private final static BCrypt.Verifyer bcryptVerifier = BCrypt.verifyer(BCrypt.Version.VERSION_2A);
	private static final int PASSWORD_SIZE = 72;
	private static final int SALT_SIZE = 64;
	private static final int SALT_SIZE2 = 64;
	private static final int INT32_LENGTH = String.valueOf(Integer.MAX_VALUE).length();
	public static int[] generateProofOfWorkPool(String salt, String suffix,
	                                            int max_hash_val,
	                                            int poolSize,
	                                            long timeout) {
		CRC32 crc32 = new CRC32();
		final char[] passwordBuf = new char[suffix.length() + 8];
		assert passwordBuf.length <= 72 : passwordBuf.length + " > 72";
		var charsBuf = new CharSequenceByArray(passwordBuf);
		var suffixBuf = suffix.toCharArray();
		System.arraycopy(suffixBuf, 0, passwordBuf, 4 * 2, suffixBuf.length);
		int[] result = new int[poolSize];
		var startTime = RU.time();
		ByteArrayOutputStream temp = new ByteArrayOutputStream();
		StringBuilder temp2 = new StringBuilder();
		int prefix = 0;
		for (var e = 0; e < poolSize; e++) {
			while (true) {
//				if (RU.time() - startTime > timout) {
//					throw new TimeoutException();
//				}
				HexUtils.toHexString(prefix, passwordBuf, 0);
				if (checkProofOfWorkHash(salt, charsBuf, max_hash_val, crc32, temp, temp2)) {
					result[e] = prefix++;
					break;
				}
				prefix++;
			}
		}
		return result;
	}
	public static boolean checkProofOfWorkHashList(String salt, String suffix, int[] passwords, int max_hash_val) {
		CRC32 crc32 = new CRC32();
		final char[] passwordBuf = new char[suffix.length() + 8];
		assert passwordBuf.length <= 72 : passwordBuf.length + " > 72";
		var suffixBuf = suffix.toCharArray();
		System.arraycopy(suffixBuf, 0, passwordBuf, 4 * 2, suffixBuf.length);
		var charsBuf = new CharSequenceByArray(passwordBuf);
		ByteArrayOutputStream temp = new ByteArrayOutputStream();
		StringBuilder temp2 = new StringBuilder();
		for (var p : passwords) {
			HexUtils.toHexString(p, charsBuf.data, 0);
			if (!checkProofOfWorkHash(salt, charsBuf, max_hash_val, crc32, temp, temp2)) {
				return false;
			}
		}
		return true;
	}
	private static boolean checkProofOfWorkHash(String salt, CharSequence password, int max_hash_val, CRC32 crc32, ByteArrayOutputStream temp, StringBuilder temp2) {
		var hash = BCrypt.hashpw(password, salt, temp, temp2);
		crc32.reset();
		crc32.update(hash.getBytes(StandardCharsets.US_ASCII));
		return Math.abs((int) crc32.getValue()) <= max_hash_val;
	}
}
