package io.aether.api.common;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProviderFactory;
import io.aether.crypto.KeyType;

public interface KeySymmetricUtil extends KeyUtil {
    byte[] getData();

    default AKey convert() {
        if (this instanceof SodiumChacha20Poly1305) {
            return CryptoProviderFactory.getProvider("SODIUM").createKey(KeyType.SYMMETRIC, getData());
        } else if (this instanceof HydrogenSecretBox) {
            return CryptoProviderFactory.getProvider("HYDROGEN").createKey(KeyType.SYMMETRIC, getData());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    static KeySymmetric of(AKey key) {
        switch (key.getProviderName().toLowerCase()) {
            case "sodium":
                return new SodiumChacha20Poly1305(key.getData());
            case "hydrogen":
                return new HydrogenSecretBox(key.getData());
        }
        throw new UnsupportedOperationException();
    }
}
