package io.aether.api.common;

import io.aether.crypto.SignChecker;

public interface SignedKeyUtil {
    Key getKey();

    Sign getSign();

    static io.aether.crypto.SignedKey of(SignedKey key) {
        return new io.aether.crypto.SignedKey(KeyUtil.of(key.getKey()), SignUtil.of(key.getSign()));
    }

    static boolean verifySign(SignedKey key,Iterable<SignChecker> checkers) {
        var k = KeyUtil.of(key.getKey());
        var s = SignUtil.of(key.getSign());
        for (var c : checkers) {
            if (c.getCryptoProvider() == k.getCryptoProvider() && c.checkSign(k.getData(), s)) return true;
        }
        return false;
    }

    static SignedKey of(io.aether.crypto.SignedKey key) {
        return new SignedKey(KeyUtil.of(key.key), SignUtil.of(key.sign));
    }

}
