package io.aether.common.expressions;

import io.aether.net.fastMeta.AetherException;
import io.aether.net.exceptions.ErrorId;
import io.aether.utils.CTypeI;

public final class Add extends BinOperator {
	@Override
	protected void prepareForContext0() {
		var t1 = left.type;
		var t2 = right.type;
		if (!NUMBER_TYPES.contains(t1) && t1 != CTypeI.STRING) throw new AetherException( "Bad type argument for operation DIV");
		if (!NUMBER_TYPES.contains(t2) && t2 != CTypeI.STRING) throw new AetherException( "Bad type argument for operation DIV");
		if (t1 == CTypeI.STRING || t2 == CTypeI.STRING) {
			calculate = new Calculate() {
				@Override
				public Object calc() {
					var v1 = left.calculate.calc();
					var v2 = right.calculate.calc();
					return String.valueOf(v1) + v2;
				}
				@Override
				public boolean calcBoolean() {
					return Boolean.parseBoolean((String) calc());
				}
				@Override
				public byte calcByte() {
					return 0;
				}
				@Override
				public short calcShort() {
					return 0;
				}
				@Override
				public int calcInt() {
					return 0;
				}
				@Override
				public long calcLong() {
					return 0;
				}
				@Override
				public double calcDouble() {
					return 0;
				}
				@Override
				public float calcFloat() {
					return 0;
				}
			};
		} else if (t1 == CTypeI.DOUBLE || t1 == CTypeI.FLOAT ||
                   t2 == CTypeI.DOUBLE || t2 == CTypeI.FLOAT) {
			calculate = new Calculate() {
				@Override
				public Object calc() {
					return calcDouble();
				}
				@Override
				public boolean calcBoolean() {
					return calcDouble() != 0;
				}
				@Override
				public byte calcByte() {
					return (byte) calcDouble();
				}
				@Override
				public short calcShort() {
					return (short) calcDouble();
				}
				@Override
				public int calcInt() {
					return (int) calcDouble();
				}
				@Override
				public long calcLong() {
					return (long) calcDouble();
				}
				@Override
				public double calcDouble() {
					var v1 = left.calculate.calcDouble();
					var v2 = right.calculate.calcDouble();
					return v1 + v2;
				}
				@Override
				public float calcFloat() {
					return (float) calcDouble();
				}
			};
		} else if (t1 == CTypeI.LONG || t2 == CTypeI.LONG) {
			calculate = new Calculate() {
				@Override
				public Object calc() {
					return calcLong();
				}
				@Override
				public boolean calcBoolean() {
					return calcLong() != 0;
				}
				@Override
				public byte calcByte() {
					return (byte) calcLong();
				}
				@Override
				public short calcShort() {
					return (short) calcLong();
				}
				@Override
				public int calcInt() {
					return (int) calcLong();
				}
				@Override
				public long calcLong() {
					var v1 = left.calculate.calcLong();
					var v2 = right.calculate.calcLong();
					return v1 + v2;
				}
				@Override
				public double calcDouble() {
					return calcLong();
				}
				@Override
				public float calcFloat() {
					return calcLong();
				}
			};
		} else {
			calculate = new Calculate() {
				@Override
				public Object calc() {
					return calcInt();
				}
				@Override
				public boolean calcBoolean() {
					return calcInt() != 0;
				}
				@Override
				public byte calcByte() {
					return (byte) calcInt();
				}
				@Override
				public short calcShort() {
					return (short) calcInt();
				}
				@Override
				public int calcInt() {
					var v1 = left.calculate.calcInt();
					var v2 = right.calculate.calcInt();
					return v1 + v2;
				}
				@Override
				public long calcLong() {
					return calcInt();
				}
				@Override
				public double calcDouble() {
					return calcInt();
				}
				@Override
				public float calcFloat() {
					return calcInt();
				}
			};
		}
	}
}
