package io.aether.common.expressions;

import io.aether.utils.CTypeI;

public final class LiteralArrayInt16 extends Expression {
	public short[] value;
	@Override
	protected void prepareForContext0() {
		typeRaw = short[].class;
		type = CTypeI.SHORT_ARR;
		calculate = new Calculate() {
			@Override
			public Object calc() {
				return value;
			}
			@Override
			public boolean calcBoolean() {
				return value != null;
			}
			@Override
			public byte calcByte() {
				return (byte) value.length;
			}
			@Override
			public short calcShort() {
				return (short) value.length;
			}
			@Override
			public int calcInt() {
				return value.length;
			}
			@Override
			public long calcLong() {
				return value.length;
			}
			@Override
			public double calcDouble() {
				return value.length;
			}
			@Override
			public float calcFloat() {
				return value.length;
			}
		};
	}
}
