package io.aether.common.expressions;

import io.aether.utils.CTypeI;

public final class LiteralInt16 extends Expression {
	public short value;
	@Override
	protected void prepareForContext0() {
		type = CTypeI.SHORT;
		typeRaw = short.class;
		byte valueByte = (byte) value;
		short valueShort = value;
		int valueInt = value;
		long valueLong = value;
		float valueFloat = value;
		double valueDouble = value;
		boolean valueBoolean = value != 0;
		Object valueObject = value;
		calculate = new Calculate() {
			@Override
			public Object calc() {
				return valueObject;
			}
			@Override
			public boolean calcBoolean() {
				return valueBoolean;
			}
			@Override
			public byte calcByte() {
				return valueByte;
			}
			@Override
			public short calcShort() {
				return valueShort;
			}
			@Override
			public int calcInt() {
				return valueInt;
			}
			@Override
			public long calcLong() {
				return valueLong;
			}
			@Override
			public double calcDouble() {
				return valueDouble;
			}
			@Override
			public float calcFloat() {
				return valueFloat;
			}
		};
	}
}
