package io.aether.common.expressions;

import io.aether.net.fastMeta.AetherException;
import io.aether.net.exceptions.ErrorId;

public final class Variable extends Expression {
	public Variable() {
	}

	public Variable(int position) {
		this.position = position;
	}

	public int position;
	@Override
	protected void prepareForContext0() {
		type = ctx.variablesTypes[position];
		typeRaw = type.getRaw2();
		if (typeRaw.isPrimitive()) {
			if (NUMBER_TYPES.contains(typeRaw)) {
				calculate = new Calculate() {
					@Override
					public Object calc() {
						return ctx.variables[position];
					}
					@Override
					public boolean calcBoolean() {
						var v = ctx.variables[position];
						return ((Number) v).intValue() != 0;
					}
					@Override
					public byte calcByte() {
						var v = ctx.variables[position];
						return ((Number) v).byteValue();
					}
					@Override
					public short calcShort() {
						var v = ctx.variables[position];
						return ((Number) v).shortValue();
					}
					@Override
					public int calcInt() {
						var v = ctx.variables[position];
						return ((Number) v).intValue();
					}
					@Override
					public long calcLong() {
						var v = ctx.variables[position];
						return ((Number) v).longValue();
					}
					@Override
					public double calcDouble() {
						var v = ctx.variables[position];
						return ((Number) v).doubleValue();
					}
					@Override
					public float calcFloat() {
						var v = ctx.variables[position];
						return ((Number) v).floatValue();
					}
				};
			} else if (typeRaw == boolean.class) {
				calculate = new Calculate() {
					@Override
					public Object calc() {
						return ctx.variables[position];
					}
					@Override
					public boolean calcBoolean() {
						var v = ctx.variables[position];
						if (v == null) return false;
						return (Boolean) v;
					}
					@Override
					public byte calcByte() {
						var v = ctx.variables[position];
						if (v == null) return 0;
						return ((Boolean) v) ? (byte) 1 : 0;
					}
					@Override
					public short calcShort() {
						var v = ctx.variables[position];
						if (v == null) return 0;
						return ((Boolean) v) ? (short) 1 : 0;
					}
					@Override
					public int calcInt() {
						var v = ctx.variables[position];
						if (v == null) return 0;
						return ((Boolean) v) ? 1 : 0;
					}
					@Override
					public long calcLong() {
						var v = ctx.variables[position];
						if (v == null) return 0;
						return ((Boolean) v) ? 1 : 0;
					}
					@Override
					public double calcDouble() {
						var v = ctx.variables[position];
						if (v == null) return 0;
						return ((Boolean) v) ? 1 : 0;
					}
					@Override
					public float calcFloat() {
						var v = ctx.variables[position];
						if (v == null) return 0;
						return ((Boolean) v) ? 1 : 0;
					}
				};
			}
		} else {
			calculate = new Calculate() {
				@Override
				public Object calc() {
					return ctx.variables[position];
				}
				@Override
				public boolean calcBoolean() {
					return ctx.variables[position] != null;
				}
				@Override
				public byte calcByte() {
					throw new AetherException( "Argument type is bad");
				}
				@Override
				public short calcShort() {
					throw new AetherException( "Argument type is bad");
				}
				@Override
				public int calcInt() {
					throw new AetherException( "Argument type is bad");
				}
				@Override
				public long calcLong() {
					throw new AetherException( "Argument type is bad");
				}
				@Override
				public double calcDouble() {
					throw new AetherException( "Argument type is bad");
				}
				@Override
				public float calcFloat() {
					throw new AetherException( "Argument type is bad");
				}
			};
		}
	}
}
