package io.aether.utils.streams;

import java.util.concurrent.atomic.AtomicLong;

public class BlockMgr {
    private final AtomicLong currentBlock = new AtomicLong();

    public boolean unblock(long id) {
        while (true) {
            var c = currentBlock.get();
            if (c == id) return true;
            if (c < 0) {
                var cc = -c;
                if (cc < id) {
                    if (currentBlock.compareAndSet(c, id)) return true;
                } else {
                    return false;
                }
            } else {
                if (currentBlock.compareAndSet(c, id)) return true;
            }
        }
    }

    public boolean isBlocked() {
        return currentBlock.get() < 0;
    }

    public boolean block(long id) {
        var a = Math.abs(id);
        var aa = -a;
        while (true) {
            var c = currentBlock.get();
            var cc = Math.abs(c);
            if (c == aa) return true;
            if (cc > a) {
                return c < 0;
            } else {
                if (currentBlock.compareAndSet(c, aa)) return true;
            }
        }
    }

    public boolean block() {
        return block(Value.BLOCK_COUNTER.incrementAndGet());
    }

    public long get() {
        return currentBlock.get();
    }
}
