package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.ToString;
import io.aether.utils.interfaces.AConsumer;

public class OfConsumerValue<TWrite, TRead> implements AcceptorI<TWrite, TRead>, ToString {
    private final AConsumer<Value<TRead>> consumer;
    private final String name;
    public OfConsumerValue(String name, AConsumer<Value<TRead>> consumer) {
        this.consumer = consumer;
        this.name = name;
    }

    @Override
    public void toString(AString sb) {
        sb.add("GateConsumerValue(").add(name).add(":").add(consumer).add(")");
    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public void send(FGate<TRead, TWrite> fGate, Value<TRead> value) {
        consumer.accept(value);
    }

}
