package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.WeakCollection;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.slots.EventConsumer;

import java.lang.invoke.VarHandle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class Switcher2<TUp, TDown> implements ToString {
    private final WeakCollection<FGate<TDown, TUp>> ups = new WeakCollection<>();
    private final ConcurrentLinkedQueue<FGate<TDown, TUp>> upsHard = new ConcurrentLinkedQueue<>();
    private final EventConsumer<FGate<TDown, TUp>> onLink = new EventConsumer<>();
    private final EventConsumer<GateI<TUp>> onFirstSoftWritable = new EventConsumer<>();
    public final BlockMgr blockMgrGlobal = new BlockMgr();

    public Switcher2() {
    }

    public void onLink(AConsumer<FGate<TDown, TUp>> c) {
        onLink.add(c);
    }

    @Override
    public void toString(AString sb) {
        sb.add("switcher(").add(ups.size()).add(":").add(upsHard.size()).add(")");
    }

    @Override
    public String toString() {
        return toString2();
    }

    public Gate<TDown, TUp> linkUp(Gate<TUp, TDown> up) {
        var gInner = linkUp();
        gInner.link(up);
        return gInner;
    }

    public Gate<TDown, TUp> linkUp() {
        FGate<TDown, TUp> gInner = FGate.of(new SplitterUpGateSoft());
        return gInner.outSide();
    }

    public Gate<TDown, TUp> linkUpHard(Gate<TUp, TDown> up) {
        var gInner = linkUpHard();
        gInner.link(up);
        return gInner;
    }

    public Gate<TDown, TUp> linkUpHard() {
        FGate<TDown, TUp> gInner = FGate.of(new SplitterUpGateHard());
        return gInner.outSide();
    }

    public void flushUp() {
        for (var g : ups) {
            g.inSide.send(Value.ofForce());
        }
        for (var g : upsHard) {
            g.inSide.send(Value.ofForce());
        }
    }

    protected void sendUp(Value<TUp> value, FGate<TDown, TUp> g, AtomicInteger abortCounter, AtomicBoolean finalFlag) {
        var sup = RU.<SplitterUpGate>cast(g.acceptor);
        abortCounter.incrementAndGet();
        g.inSide.send(new ValueProxy<>(value) {
            @Override
            public void success(Object owner) {
                if (finalFlag.compareAndSet(false, true)) {
                    value.success(owner);
                }
            }

            @Override
            public void reject(Object owner, long blockId) {
                if (sup.blockMgr.block(blockId)) {
                    if (abortCounter.decrementAndGet() == 0 && finalFlag.compareAndSet(false, true)) {
                        if (blockMgrGlobal.block(blockId)) {
                            value.reject(Switcher2.this, blockId);
                        }
                    }
                } else {
                    sendUp(value, g, abortCounter, finalFlag);
                }
            }
        });
    }

    public void sendUp(Value<TUp> value) {
        value.enter(this);
        if (blockMgrGlobal.isBlocked()) {
            value.reject(this);
            return;
        }
        AtomicBoolean finalFlag = new AtomicBoolean();
        AtomicInteger abortCounter = new AtomicInteger(1);
        var bid = Value.BLOCK_COUNTER.incrementAndGet();
        VarHandle.fullFence();
        for (var g : Flow.flow(ups).addAll(upsHard)) {
            var sup = RU.<SplitterUpGate>cast(g.acceptor);
            if (sup.blockMgr.isBlocked()) continue;
            sendUp(value, g, abortCounter, finalFlag);
        }
        if (abortCounter.decrementAndGet() == 0 && finalFlag.compareAndSet(false, true)) {
            if (blockMgrGlobal.block(bid)) {
                value.reject(Switcher2.this, blockMgrGlobal.get());
            } else {
                sendUp(value);
            }
        }
    }

    public boolean existsLinks() {
        return !ups.isEmpty() || !upsHard.isEmpty();
    }

    public void onFirstSoftWritable(AConsumer<GateI<TUp>> consumer) {
        onFirstSoftWritable.add(consumer);
    }

    public class SplitterUpGateHard extends SplitterUpGate {

        @Override
        protected void onLink(Gate<TUp, TDown> g) {
            upsHard.add(fGate);
            onLink.fire(fGate);
        }

        @Override
        public void toString(AString sb) {
            sb.add(Switcher2.this).add("(hard)").add(" -> ").add(fGate.inSide);
        }
    }

    public class SplitterUpGateSoft extends SplitterUpGate {

        @Override
        protected void onLink(Gate<TUp, TDown> g) {
            ups.add(fGate);
            onLink.fire(fGate);
        }

        @Override
        public void toString(AString sb) {
            sb.add(Switcher2.this).add("(soft)").add(" -> ").add(fGate.inSide);
        }
    }

    protected void sendToDown2(SplitterUpGate sup, FGate<TDown, TUp> fGate, Value<TDown> value) {

    }

    protected void onFirstRequest(SplitterUpGate sup, FGate<TDown, TUp> fGate, Value<TDown> value) {

    }

    protected void sendToDown(SplitterUpGate sup, FGate<TDown, TUp> fGate, Value<TDown> value) {
        value.enter(Switcher2.this);
        if (value.isClose()) {
            ups.remove(fGate);
            upsHard.remove(fGate);
            value = value.notClose();
        }
        if (value.isOnlyRequestData()) {
            if (sup.blockMgr.unblock(value.getRequestDataId())) {
                blockMgrGlobal.unblock(value.getRequestDataId());
                if (sup.firstRequestData.compareAndSet(false, true)) {
                    onLink.fire(fGate);
                    sup.onLink(fGate.link);
                    onFirstRequest(sup, fGate, value);
                }
            }
        }
        sendToDown2(sup, fGate, value);
    }

    public abstract class SplitterUpGate implements AcceptorI<TUp, TDown> {
        public final AtomicBoolean firstRequestData = new AtomicBoolean();
        volatile FGate<TDown, TUp> fGate;
        public final BlockMgr blockMgr = new BlockMgr();

        public SplitterUpGate() {
        }

        @Override
        public String toString() {
            return toString2();
        }

        @Override
        public void setFGate(FGate<TDown, TUp> g) {
            fGate = g;
        }

        protected abstract void onLink(Gate<TUp, TDown> g);

        @Override
        public void send(FGate<TDown, TUp> fGate, Value<TDown> value) {
            sendToDown(this, fGate, value);
        }

    }


}

