package io.aether.utils.streams;

import io.aether.logger.Log;
import io.aether.utils.AString;

public class ValueProxy<T> implements Value<T> {
    protected final Value<T> self;

    public ValueProxy(Value<T> self) {
        this.self = self;
    }

    @Override
    public String toString() {
        return self.toString2();
    }

    @Override
    public void toString(AString sb) {
        self.toString(sb);
    }

    @Override
    public T data() {
        return self.data();
    }

    @Override
    public void success(Object owner) {
        try {
            self.success(owner);
        } catch (Exception e) {
            Log.error(e);
        }
    }

    @Override
    public void enter(Object owner) {
        try {
            self.enter(owner);
        } catch (Exception e) {
            Log.error(e);
        }
    }

    @Override
    public boolean isForce() {
        return self.isForce();
    }

    @Override
    public int priority() {
        return self.priority();
    }

    @Override
    public boolean isRequestData() {
        return self.isRequestData();
    }

    @Override
    public long getRequestDataId() {
        return self.getRequestDataId();
    }

    @Override
    public boolean isClose() {
        return self.isClose();
    }


    @Override
    public void reject(Object owner, long blockId) {
        try {
            self.reject(owner, blockId);
        } catch (Exception e) {
            Log.error(e);
        }
    }

    @Override
    public boolean isData() {
        return self.isData();
    }
}
