package io.aether.utils.streams;

import io.aether.logger.Log;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;

public class ValueProxyTimeout<T> extends ValueProxy<T> {
    final ConcurrentLinkedQueue<Object> lastEnter;
    final ScheduledFuture<?> sch;

    public ValueProxyTimeout(Value<T> self, long time) {
        super(self);
        lastEnter = new ConcurrentLinkedQueue<>();
        sch = RU.schedule(time, () -> {
            Log.warn("timeout value completed value(isData:$isData,isRequestData:$isRequestData,isForce:$isForce,isClose:$isClose,isData:$isData)\n$enter",
                    "enter", Flow.flow(lastEnter).join("\n"),
                    "value", self,
                    "isRequestData", self.isRequestData(),
                    "isForce", self.isForce(),
                    "isData", self.isData(),
                    "isClose", self.isClose()
            );
        });
    }

    @Override
    public void reject(Object owner, long blockId) {
        sch.cancel(false);
        super.reject(owner, blockId);
    }

    @Override
    public void success(Object owner) {
        sch.cancel(false);
        super.success(owner);
    }

    @Override
    public void enter(Object owner) {
        lastEnter.add(owner);
        super.enter(owner);
    }
}
