package io.aether.utils.streams;

import io.aether.utils.AString;

import java.util.Collection;

public class ValueWithSubValues<T> implements Value<T> {
    private final T data;
    private final boolean force;
    private final Collection<Value<?>> subValues;

    public ValueWithSubValues(T data, boolean force, Collection<Value<?>> subValues) {
        this.data = data;
        this.force = force;
        this.subValues = subValues;
    }

    @Override
    public T data() {
        return data;
    }

    @Override
    public void enter(Object owner) {
        for (var e : subValues) {
            e.enter(owner);
        }
    }

    @Override
    public boolean isData() {
        return true;
    }

    @Override
    public void reject(Object owner, long blockId) {
        for (var e : subValues) {
            e.reject(owner);
        }
    }

    @Override
    public boolean isForce() {
        return force;
    }

    @Override
    public void success(Object owner) {
        for (var v : subValues) {
            v.success(owner);
        }
    }

    @Override
    public String toString() {
        return toString2();
    }

    @Override
    public void toString(AString sb) {
        sb.addVars("value($force:$data)", "data", data, "force", force);
    }
}
