/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.common;

import io.aether.api.common.HydrogenSecretBox;
import io.aether.api.common.KeySymmetric;
import io.aether.api.common.KeyUtil;
import io.aether.api.common.SodiumChacha20Poly1305;
import io.aether.crypto.AKey;
import io.aether.crypto.CryptoProviderFactory;
import io.aether.crypto.KeyType;

public interface KeySymmetricUtil
extends KeyUtil {
    @Override
    public byte[] getData();

    default public AKey convert() {
        if (this instanceof SodiumChacha20Poly1305) {
            return CryptoProviderFactory.getProvider("SODIUM").createKey(KeyType.SYMMETRIC, this.getData());
        }
        if (this instanceof HydrogenSecretBox) {
            return CryptoProviderFactory.getProvider("HYDROGEN").createKey(KeyType.SYMMETRIC, this.getData());
        }
        throw new UnsupportedOperationException();
    }

    public static KeySymmetric of(AKey key) {
        switch (key.getProviderName().toLowerCase()) {
            case "sodium": {
                return new SodiumChacha20Poly1305(key.getData());
            }
            case "hydrogen": {
                return new HydrogenSecretBox(key.getData());
            }
        }
        throw new UnsupportedOperationException();
    }
}

