/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.common;

import io.aether.api.common.HydrogenCurvePrivate;
import io.aether.api.common.HydrogenCurvePublic;
import io.aether.api.common.HydrogenSecretBox;
import io.aether.api.common.HydrogenSignPrivate;
import io.aether.api.common.HydrogenSignPublic;
import io.aether.api.common.Key;
import io.aether.api.common.SodiumChacha20Poly1305;
import io.aether.api.common.SodiumCurvePrivate;
import io.aether.api.common.SodiumCurvePublic;
import io.aether.api.common.SodiumSignPrivate;
import io.aether.api.common.SodiumSignPublic;
import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProviderFactory;
import io.aether.crypto.KeyType;
import io.aether.utils.RU;

public interface KeyUtil {
    public byte[] getData();

    public static <T extends AKey> T of(Key key) {
        if (key instanceof SodiumCurvePrivate) {
            return CryptoProviderFactory.getProvider("SODIUM").createKey(KeyType.ASYMMETRIC_PRIVATE, key.getData());
        }
        if (key instanceof SodiumSignPublic) {
            return CryptoProviderFactory.getProvider("SODIUM").createKey(KeyType.SIGN_PUBLIC, key.getData());
        }
        if (key instanceof SodiumSignPrivate) {
            return CryptoProviderFactory.getProvider("SODIUM").createKey(KeyType.SIGN_PRIVATE, key.getData());
        }
        if (key instanceof SodiumCurvePublic) {
            return CryptoProviderFactory.getProvider("SODIUM").createKey(KeyType.ASYMMETRIC_PUBLIC, key.getData());
        }
        if (key instanceof HydrogenCurvePrivate) {
            return CryptoProviderFactory.getProvider("HYDROGEN").createKey(KeyType.ASYMMETRIC_PRIVATE, key.getData());
        }
        if (key instanceof HydrogenCurvePublic) {
            return CryptoProviderFactory.getProvider("HYDROGEN").createKey(KeyType.ASYMMETRIC_PUBLIC, key.getData());
        }
        if (key instanceof HydrogenSignPublic) {
            return CryptoProviderFactory.getProvider("HYDROGEN").createKey(KeyType.SIGN_PUBLIC, key.getData());
        }
        if (key instanceof HydrogenSignPrivate) {
            return CryptoProviderFactory.getProvider("HYDROGEN").createKey(KeyType.SIGN_PRIVATE, key.getData());
        }
        if (key instanceof SodiumChacha20Poly1305) {
            return CryptoProviderFactory.getProvider("SODIUM").createKey(KeyType.SYMMETRIC, key.getData());
        }
        if (key instanceof HydrogenSecretBox) {
            return CryptoProviderFactory.getProvider("HYDROGEN").createKey(KeyType.SYMMETRIC, key.getData());
        }
        throw new UnsupportedOperationException();
    }

    public static CryptoEngine makeProvider(Key key) {
        Object k = KeyUtil.of(key);
        switch (k.getKeyType()) {
            case ASYMMETRIC_PUBLIC: {
                return ((AKey.AsymmetricPublic)k).toCryptoEngine();
            }
            case SYMMETRIC: {
                return ((AKey.Symmetric)k).toCryptoEngine();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static <T extends Key> T of(AKey key) {
        switch (key.getProviderName().toLowerCase()) {
            case "sodium": {
                switch (key.getKeyType()) {
                    case SYMMETRIC: {
                        return (T)((Key)RU.cast((Object)new SodiumChacha20Poly1305(key.getData())));
                    }
                    case ASYMMETRIC_PRIVATE: {
                        return (T)((Key)RU.cast((Object)new SodiumCurvePrivate(key.getData())));
                    }
                    case ASYMMETRIC_PUBLIC: {
                        return (T)((Key)RU.cast((Object)new SodiumCurvePublic(key.getData())));
                    }
                    case SIGN_PRIVATE: {
                        return (T)((Key)RU.cast((Object)new SodiumSignPrivate(key.getData())));
                    }
                    case SIGN_PUBLIC: {
                        return (T)((Key)RU.cast((Object)new SodiumSignPublic(key.getData())));
                    }
                }
                throw new UnsupportedOperationException();
            }
            case "hydrogen": {
                switch (key.getKeyType()) {
                    case SYMMETRIC: {
                        return (T)((Key)RU.cast((Object)new HydrogenSecretBox(key.getData())));
                    }
                    case ASYMMETRIC_PRIVATE: {
                        return (T)((Key)RU.cast((Object)new HydrogenCurvePrivate(key.getData())));
                    }
                    case ASYMMETRIC_PUBLIC: {
                        return (T)((Key)RU.cast((Object)new HydrogenCurvePublic(key.getData())));
                    }
                    case SIGN_PRIVATE: {
                        return (T)((Key)RU.cast((Object)new HydrogenSignPrivate(key.getData())));
                    }
                    case SIGN_PUBLIC: {
                        return (T)((Key)RU.cast((Object)new HydrogenSignPublic(key.getData())));
                    }
                }
                throw new UnsupportedOperationException();
            }
        }
        throw new UnsupportedOperationException();
    }
}

