/*
 * Decompiled with CFR 0.152.
 */
package io.aether.api.common;

import io.aether.api.common.Key;
import io.aether.api.common.KeyUtil;
import io.aether.api.common.Sign;
import io.aether.api.common.SignUtil;
import io.aether.api.common.SignedKey;
import io.aether.crypto.AKey;
import io.aether.crypto.SignChecker;

public interface SignedKeyUtil {
    public Key getKey();

    public Sign getSign();

    public static io.aether.crypto.SignedKey of(SignedKey key) {
        return new io.aether.crypto.SignedKey((AKey)KeyUtil.of(key.getKey()), SignUtil.of(key.getSign()));
    }

    public static boolean verifySign(SignedKey key, Iterable<SignChecker> checkers) {
        Object k = KeyUtil.of(key.getKey());
        io.aether.crypto.Sign s = SignUtil.of(key.getSign());
        for (SignChecker c : checkers) {
            if (c.getCryptoProvider() != k.getCryptoProvider() || !c.checkSign(k.getData(), s)) continue;
            return true;
        }
        return false;
    }

    public static SignedKey of(io.aether.crypto.SignedKey key) {
        return new SignedKey(KeyUtil.of(key.key), SignUtil.of(key.sign));
    }
}

