/*
 * Decompiled with CFR 0.152.
 */
package io.aether.common.expressions;

import io.aether.common.expressions.Calculate;
import io.aether.common.expressions.Expression;
import io.aether.net.fastMeta.AetherException;

public final class Variable
extends Expression {
    public int position;

    public Variable() {
    }

    public Variable(int position) {
        this.position = position;
    }

    @Override
    protected void prepareForContext0() {
        this.type = this.ctx.variablesTypes[this.position];
        this.typeRaw = this.type.getRaw2();
        if (this.typeRaw.isPrimitive()) {
            if (NUMBER_TYPES.contains(this.typeRaw)) {
                this.calculate = new Calculate(){

                    @Override
                    public Object calc() {
                        return Variable.this.ctx.variables[Variable.this.position];
                    }

                    @Override
                    public boolean calcBoolean() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        return ((Number)v).intValue() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        return ((Number)v).byteValue();
                    }

                    @Override
                    public short calcShort() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        return ((Number)v).shortValue();
                    }

                    @Override
                    public int calcInt() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        return ((Number)v).intValue();
                    }

                    @Override
                    public long calcLong() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        return ((Number)v).longValue();
                    }

                    @Override
                    public double calcDouble() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        return ((Number)v).doubleValue();
                    }

                    @Override
                    public float calcFloat() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        return ((Number)v).floatValue();
                    }
                };
            } else if (this.typeRaw == Boolean.TYPE) {
                this.calculate = new Calculate(){

                    @Override
                    public Object calc() {
                        return Variable.this.ctx.variables[Variable.this.position];
                    }

                    @Override
                    public boolean calcBoolean() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        if (v == null) {
                            return false;
                        }
                        return (Boolean)v;
                    }

                    @Override
                    public byte calcByte() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        if (v == null) {
                            return 0;
                        }
                        return (Boolean)v != false ? (byte)1 : 0;
                    }

                    @Override
                    public short calcShort() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        if (v == null) {
                            return 0;
                        }
                        return (Boolean)v != false ? (short)1 : 0;
                    }

                    @Override
                    public int calcInt() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        if (v == null) {
                            return 0;
                        }
                        return (Boolean)v != false ? 1 : 0;
                    }

                    @Override
                    public long calcLong() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        if (v == null) {
                            return 0L;
                        }
                        return (Boolean)v != false ? 1L : 0L;
                    }

                    @Override
                    public double calcDouble() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        if (v == null) {
                            return 0.0;
                        }
                        return (Boolean)v != false ? 1.0 : 0.0;
                    }

                    @Override
                    public float calcFloat() {
                        Object v = Variable.this.ctx.variables[Variable.this.position];
                        if (v == null) {
                            return 0.0f;
                        }
                        return (Boolean)v != false ? 1.0f : 0.0f;
                    }
                };
            }
        } else {
            this.calculate = new Calculate(){

                @Override
                public Object calc() {
                    return Variable.this.ctx.variables[Variable.this.position];
                }

                @Override
                public boolean calcBoolean() {
                    return Variable.this.ctx.variables[Variable.this.position] != null;
                }

                @Override
                public byte calcByte() {
                    throw new AetherException("Argument type is bad");
                }

                @Override
                public short calcShort() {
                    throw new AetherException("Argument type is bad");
                }

                @Override
                public int calcInt() {
                    throw new AetherException("Argument type is bad");
                }

                @Override
                public long calcLong() {
                    throw new AetherException("Argument type is bad");
                }

                @Override
                public double calcDouble() {
                    throw new AetherException("Argument type is bad");
                }

                @Override
                public float calcFloat() {
                    throw new AetherException("Argument type is bad");
                }
            };
        }
    }
}

