/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto;

import io.aether.crypto.CryptoEngine;
import io.aether.crypto.CryptoProviderFactory;
import io.aether.crypto.CryptoProviderUnit;
import io.aether.crypto.KeyType;
import io.aether.crypto.Sign;
import io.aether.crypto.SignChecker;
import io.aether.crypto.SignedKey;
import io.aether.crypto.Signer;
import io.aether.utils.HexUtils;
import io.aether.utils.RU;

public interface AKey
extends CryptoProviderUnit {
    public byte[] getData();

    public KeyType getKeyType();

    public int size();

    default public SignedKey toSignedKey(Signer signer) {
        return new SignedKey(this, signer.sign(this.getData()));
    }

    default public SignedKey toSignedKey(Sign sign) {
        return new SignedKey(this, sign);
    }

    default public String keyToString() {
        return this.getProviderName() + ":" + String.valueOf((Object)this.getKeyType()) + ":" + HexUtils.toHexString((byte[])this.getData());
    }

    default public Symmetric asSymmetric() {
        return (Symmetric)this;
    }

    default public AsymmetricPublic asAsymmetric() {
        return (AsymmetricPublic)this;
    }

    default public SignPublic asSignPublicKey() {
        return (SignPublic)this;
    }

    public static <T extends AKey> T of(String v) {
        return (T)((AKey)RU.cast((Object)CryptoProviderFactory.createKey(v)));
    }

    public static interface SignPrivate
    extends AKey {
    }

    public static interface SignPublic
    extends AKey {
        public SignChecker toSignChecker();
    }

    public static interface AsymmetricPrivate
    extends AKey {
    }

    public static interface AsymmetricPublic
    extends AKey {
        public CryptoEngine toCryptoEngine();
    }

    public static interface Symmetric
    extends AKey {
        public CryptoEngine toCryptoEngine();
    }
}

