/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoEngine;
import io.aether.crypto.KeyType;
import io.aether.crypto.PairAsymKeys;
import io.aether.crypto.PairSignKeys;
import io.aether.crypto.Sign;
import io.aether.crypto.SignedKey;
import io.aether.crypto.Signer;
import io.aether.utils.HexUtils;

public interface CryptoProvider {
    public String getCryptoLibName();

    public PairAsymKeys createAsymmetricKeys();

    public AKey.Symmetric createSymmetricKey();

    public PairSignKeys createSignKeys();

    default public SignedKey createSignedKey(String data) {
        String unifiedData = data.replace('|', ':');
        String[] parts = unifiedData.split(":");
        String currentProviderName = this.getCryptoLibName();
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid signed key string format. Expected 4 parts: PROVIDER:TYPE:KEY_DATA:SIGN_DATA.");
        }
        if (!parts[0].equals(currentProviderName)) {
            throw new IllegalArgumentException("Key provider '" + parts[0] + "' must match the current provider: " + currentProviderName);
        }
        String keyString = parts[0] + ":" + parts[1] + ":" + parts[2];
        Object key = this.createKey(keyString);
        String signString = parts[0] + ":" + parts[3];
        Sign sign = this.createSign(signString);
        return new SignedKey((AKey)key, sign);
    }

    default public PairSignKeys createSignKeys(byte[] publicKey, byte[] privateKey) {
        return new PairSignKeys((AKey.SignPublic)this.createKey(KeyType.SIGN_PUBLIC, publicKey), (AKey.SignPrivate)this.createKey(KeyType.SIGN_PRIVATE, privateKey));
    }

    default public PairSignKeys createSignKeys(String publicKey, String privateKey) {
        return this.createSignKeys(HexUtils.hexToBytes((CharSequence)publicKey), HexUtils.hexToBytes((CharSequence)privateKey));
    }

    public Signer createSigner(PairSignKeys var1);

    public Signer createSigner(AKey.SignPublic var1, AKey.SignPrivate var2);

    public Signer createSigner(AKey.SignPublic var1);

    public CryptoEngine createSymmetricEngine(AKey.Symmetric var1);

    public CryptoEngine createAsymmetricEngine(AKey.AsymmetricPublic var1);

    public CryptoEngine createAsymmetricEngine(AKey.AsymmetricPrivate var1, AKey.AsymmetricPublic var2);

    public CryptoEngine createAsymmetricEngine(PairAsymKeys var1);

    public <T extends AKey> T createKey(KeyType var1, byte[] var2);

    public <T extends AKey> T createKey(String var1);

    default public SignedKey createSignedKey(KeyType keyType, byte[] key, byte[] sign) {
        Object k = this.createKey(keyType, key);
        return k.toSignedKey(this.createSign(sign));
    }

    public Sign createSign(String var1);

    public Sign createSign(byte[] var1);

    default public AKey.Symmetric createKeyForServer(AKey.Symmetric masterKey, int sid) {
        return masterKey;
    }

    default public AKey.Symmetric createKeyForClient(AKey.Symmetric masterKey, int sid) {
        return masterKey;
    }

    public AKey.SignPublic createSignPublicKey(byte[] var1);

    public AKey.SignPrivate createSignPrivateKey(byte[] var1);

    default public PairSignKeys createSignKeys(String text) {
        if (text.contains("|")) {
            String[] parts = text.split("\\|");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid PairSignKeys format with '|' separator. Expected: PUBLIC_KEY_STRING|PRIVATE_KEY_STRING.");
            }
            AKey.SignPublic publicKey = (AKey.SignPublic)this.createKey(parts[0]);
            AKey.SignPrivate privateKey = (AKey.SignPrivate)this.createKey(parts[1]);
            return new PairSignKeys(publicKey, privateKey);
        }
        String[] tt = text.split(":");
        String currentProviderName = this.getCryptoLibName();
        if (tt.length >= 2 && tt.length <= 3 && tt[0].equals(currentProviderName)) {
            AKey.SignPublic keyPublic = this.createSignPublicKey(HexUtils.hexToBytes((CharSequence)tt[1]));
            if (tt.length == 3) {
                AKey.SignPrivate keyPrivate = this.createSignPrivateKey(HexUtils.hexToBytes((CharSequence)tt[2]));
                return new PairSignKeys(keyPublic, keyPrivate);
            }
            return new PairSignKeys(keyPublic, null);
        }
        if (tt.length < 1 || tt.length > 2) {
            throw new IllegalArgumentException("Invalid raw hex key pair format. Expected 1 or 2 parts, found " + tt.length);
        }
        AKey.SignPublic keyPublic = this.createSignPublicKey(HexUtils.hexToBytes((CharSequence)tt[0]));
        if (tt.length > 1) {
            AKey.SignPrivate keyPrivate = this.createSignPrivateKey(HexUtils.hexToBytes((CharSequence)tt[1]));
            return new PairSignKeys(keyPublic, keyPrivate);
        }
        return new PairSignKeys(keyPublic, null);
    }

    public AKey.Symmetric createSymmetricKey(byte[] var1);

    default public Signer createSigner() {
        return this.createSigner(this.createSignKeys());
    }

    default public <T extends AKey> T createKey(KeyType keyType, String publicKey) {
        return this.createKey(keyType, HexUtils.hexToBytes((CharSequence)publicKey));
    }
}

