/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto;

import io.aether.crypto.AKey;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.KeyType;
import io.aether.crypto.PairAsymKeysSigned;
import io.aether.crypto.Sign;
import io.aether.crypto.SignChecker;
import io.aether.crypto.SignedKey;
import io.aether.crypto.Signer;
import io.aether.utils.HexUtils;
import io.aether.utils.ModuleAutoRun;
import io.aether.utils.flow.Flow;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CryptoProviderFactory {
    private static final Map<String, CryptoProvider> providers = new ConcurrentHashMap<String, CryptoProvider>();

    private CryptoProviderFactory() {
    }

    public static void register(CryptoProvider provider) {
        providers.put(provider.getCryptoLibName().toLowerCase(), provider);
    }

    public static CryptoProvider getProvider(String libName) {
        ModuleAutoRun.initialize((String)"CryptoProviderFactory");
        CryptoProvider res = providers.get(libName.toLowerCase());
        if (res == null) {
            throw new IllegalArgumentException("Provider not registered for library: " + libName);
        }
        return res;
    }

    public static CryptoProvider getProvider(AKey key) {
        return CryptoProviderFactory.getProvider(key.getProviderName());
    }

    public static CryptoProvider getProvider(Sign sign) {
        return CryptoProviderFactory.getProvider(sign.getProviderName());
    }

    public static AKey createKey(String providerName, KeyType keyType, byte[] data) {
        CryptoProvider provider = CryptoProviderFactory.getProvider(providerName);
        return provider.createKey(keyType, data);
    }

    public static AKey createKey(String s) {
        try {
            if (s == null || s.isBlank()) {
                return null;
            }
            String[] parts = s.split(":");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid admin key string format. Expected 'PROVIDER_NAME:KEY_TYPE:DATA' actual: " + s);
            }
            String providerName = parts[0];
            KeyType keyType = KeyType.valueOf(parts[1]);
            byte[] data = HexUtils.hexToBytes((CharSequence)parts[2]);
            return CryptoProviderFactory.createKey(providerName, keyType, data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid admin key: " + s, e);
        }
    }

    public static Flow<CryptoProvider> allFlow() {
        return Flow.flow(CryptoProviderFactory.all());
    }

    public static Set<CryptoProvider> all() {
        return Set.copyOf(providers.values());
    }

    public static SignChecker createSignChecker(String s) {
        if (s == null || s.isBlank()) {
            return null;
        }
        int i = s.indexOf(":");
        String providerName = s.substring(0, i);
        s = s.substring(i + 1);
        CryptoProvider cp = CryptoProviderFactory.getProvider(providerName);
        if (s.contains(":")) {
            throw new IllegalStateException(s);
        }
        return cp.createSigner(cp.createKey(KeyType.SIGN_PUBLIC, s).asSignPublicKey());
    }

    public static Set<Signer> makeSigners() {
        HashSet<Signer> res = new HashSet<Signer>();
        for (CryptoProvider p : CryptoProviderFactory.all()) {
            res.add(p.createSigner());
        }
        return res;
    }

    public static Signer createSigner(String providerName, String publicKey, String privateKey) {
        CryptoProvider p = CryptoProviderFactory.getProvider(providerName);
        return p.createSigner(p.createSignKeys(publicKey, privateKey));
    }

    public static PairAsymKeysSigned createPairKeysSigned(String providerName, String publicKey, String privateKey, Signer signer) {
        CryptoProvider p = CryptoProviderFactory.getProvider(providerName);
        Object pk = p.createKey(KeyType.ASYMMETRIC_PUBLIC, publicKey);
        return new PairAsymKeysSigned(new SignedKey((AKey)pk, signer), (AKey.AsymmetricPrivate)p.createKey(KeyType.ASYMMETRIC_PRIVATE, privateKey));
    }
}

