/*
 * Decompiled with CFR 0.152.
 */
package io.aether.crypto;

import io.aether.api.common.KeyUtil;
import io.aether.api.common.PairKeysAsymSigned;
import io.aether.api.common.SignedKeyUtil;
import io.aether.crypto.AKey;
import io.aether.crypto.CryptoProvider;
import io.aether.crypto.CryptoProviderFactory;
import io.aether.crypto.KeyType;
import io.aether.crypto.PairKeys;
import io.aether.crypto.SignedKey;
import io.aether.utils.HexUtils;

public class PairAsymKeysSigned
implements PairKeys {
    public final SignedKey publicKey;
    public final AKey.AsymmetricPrivate privateKey;

    public PairAsymKeysSigned(SignedKey publicKey, AKey.AsymmetricPrivate privateKey) {
        if (!(publicKey.key instanceof AKey.AsymmetricPublic)) {
            throw new IllegalArgumentException("Public key is bad: " + String.valueOf(publicKey));
        }
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    @Override
    public String getProviderName() {
        return this.publicKey.getProviderName();
    }

    @Override
    public CryptoProvider getCryptoProvider() {
        return this.publicKey.getCryptoProvider();
    }

    @Override
    public AKey.AsymmetricPrivate getPrivateKey() {
        return this.privateKey;
    }

    public SignedKey getPublicKeySigned() {
        return this.publicKey;
    }

    @Override
    public AKey.AsymmetricPublic getPublicKey() {
        return (AKey.AsymmetricPublic)this.publicKey.key;
    }

    public static PairAsymKeysSigned of(PairKeysAsymSigned k) {
        return new PairAsymKeysSigned(SignedKeyUtil.of(k.getPublicKey()), (AKey.AsymmetricPrivate)KeyUtil.of(k.getPrivateKey()));
    }

    public static PairAsymKeysSigned of(String k) {
        try {
            String[] kk = k.split(":");
            if (kk.length < 3) {
                throw new IllegalArgumentException("Invalid key string format. Expected at least 3 parts (Provider:PublicKey:Signature) but got " + kk.length);
            }
            String cpName = kk[0];
            CryptoProvider cp = CryptoProviderFactory.getProvider(cpName);
            byte[] publicKeyData = HexUtils.hexToBytes((CharSequence)kk[1]);
            byte[] signatureData = HexUtils.hexToBytes((CharSequence)kk[2]);
            SignedKey signedKey = cp.createSignedKey(KeyType.ASYMMETRIC_PUBLIC, publicKeyData, signatureData);
            AKey.AsymmetricPrivate privateKey = null;
            if (kk.length > 3) {
                byte[] privateKeyData = HexUtils.hexToBytes((CharSequence)kk[3]);
                privateKey = (AKey.AsymmetricPrivate)cp.createKey(KeyType.ASYMMETRIC_PRIVATE, privateKeyData);
            }
            return new PairAsymKeysSigned(signedKey, privateKey);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Parse exception for: " + k + " (Invalid data length or format)", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Parse exception for: " + k, e);
        }
    }
}

