/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.nio;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastApiContextLocal;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.net.fastMeta.SerializerPackNumber;
import io.aether.net.serialization.DeserializerSizeStream;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.futures.AFuture;
import io.aether.utils.interfaces.AFunction;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class FastApiContextClientNIO<LT, RT extends RemoteApi>
extends FastApiContextLocal<LT>
implements Runnable {
    public final FastMetaApi<LT, ?> localApiMeta;
    public final FastMetaApi<?, RT> remoteApiMeta;
    public final AFuture connectedFuture = AFuture.make();
    private final SocketChannel channel;
    private final Selector selector;
    private final SelectionKey key;
    private final ByteBuffer readBuffer = ByteBuffer.allocate(65536);
    private final ByteBuffer internalWriteBuffer = ByteBuffer.allocate(65536);
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final DeserializerSizeStream deserializerSizeStream = new DeserializerSizeStream();
    private final LNode logContext;

    public FastApiContextClientNIO(SocketChannel channel, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, AFunction<RT, LT> localApi, LNode logContext) throws IOException {
        super(c -> localApi.apply((Object)remoteApiMeta.makeRemote((FastFutureContext)c)));
        this.logContext = logContext;
        this.channel = Objects.requireNonNull(channel);
        this.localApiMeta = localApiMeta;
        this.remoteApiMeta = remoteApiMeta;
        this.selector = Selector.open();
        this.channel.configureBlocking(false);
        this.key = this.channel.register(this.selector, 8);
        this.key.attach(this);
        ExecutorService executor = Executors.newSingleThreadExecutor(r -> {
            try {
                Thread t = new Thread(r, "NIO-Client-Worker-" + ((InetSocketAddress)channel.getRemoteAddress()).getPort());
                t.setDaemon(true);
                return t;
            }
            catch (ClosedChannelException e) {
                this.destroyChannel();
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get remote address for thread name.", e);
            }
        });
        executor.execute(this);
        this.connectedFuture.onCancel(executor::shutdown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block27: {
            try {
                Log.LogAutoClose ln = Log.context((LNode)this.logContext);
                block20: while (true) {
                    while (this.channel.isOpen() && !this.isClosed.get()) {
                        if (!this.isEmpty()) {
                            this.selector.wakeup();
                        }
                        this.selector.select();
                        Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
                        while (keys.hasNext()) {
                            SelectionKey key = keys.next();
                            keys.remove();
                            if (!key.isValid()) continue;
                            try {
                                if (key.isConnectable()) {
                                    this.handleConnect(key);
                                }
                                if (key.isReadable()) {
                                    this.readFromChannel(key);
                                }
                                if (!key.isWritable()) continue;
                                this.writeToChannel(key);
                            }
                            catch (CancelledKeyException e) {
                                this.destroyChannel();
                                break;
                            }
                            catch (ClosedChannelException e) {
                                throw e;
                            }
                            catch (IOException e) {
                                Log.warn((String)"I/O error on channel: $channel", (Throwable)e, (Object[])new Object[]{"socket", "nio client", "channel", this.channel});
                                this.destroyChannel();
                            }
                        }
                        try {
                            if (!this.key.isValid() || this.isEmpty() || (this.key.interestOps() & 4) != 0) continue block20;
                            this.key.interestOps(this.key.interestOps() | 4);
                            continue block20;
                        }
                        catch (CancelledKeyException e) {
                            Log.trace((String)"SelectionKey was cancelled during interestOps modification. Exiting loop condition check.", (Object[])new Object[]{"socket", "nio client", "channel", this.channel});
                        }
                    }
                    break block27;
                    {
                        continue block20;
                        break;
                    }
                    break;
                }
                finally {
                    if (ln != null) {
                        ln.close();
                    }
                }
            }
            catch (ClosedChannelException e) {
                Log.info((String)"Client channel closed gracefully: $channel", (Object[])new Object[]{"socket", "nio client", "channel", this.channel});
                this.connectedFuture.error((Throwable)e);
            }
            catch (ClosedSelectorException e) {
                Log.info((String)"Client selector closed gracefully: $channel", (Object[])new Object[]{"socket", "nio client", "channel", this.channel});
                this.connectedFuture.error((Throwable)e);
            }
            catch (Exception e) {
                Log.warn((String)"Client worker error for channel: $channel", (Throwable)e, (Object[])new Object[]{"socket", "nio client", "channel", this.channel});
                this.connectedFuture.error((Throwable)e);
            }
            finally {
                this.destroyChannel();
            }
        }
    }

    private void handleConnect(SelectionKey key) throws IOException {
        SocketChannel ch = (SocketChannel)key.channel();
        if (ch.isConnectionPending()) {
            ch.finishConnect();
        }
        key.interestOps(1);
        this.connectedFuture.done();
        Log.info((String)"client connected successfully to: $address", (Object[])new Object[]{"socket", "nio client", "address", ch.getRemoteAddress()});
    }

    private void readFromChannel(SelectionKey key) throws IOException {
        int bytesRead = this.channel.read(this.readBuffer);
        if (bytesRead == -1) {
            throw new ClosedChannelException();
        }
        if (bytesRead == 0) {
            return;
        }
        this.readBuffer.flip();
        byte[] rawBytes = new byte[this.readBuffer.remaining()];
        this.readBuffer.get(rawBytes);
        this.readBuffer.clear();
        DataInOutStatic b = new DataInOutStatic(rawBytes);
        int totalBytes = b.getWritePos();
        while (b.isReadable()) {
            if (!this.deserializerSizeStream.put((DataIn)b)) {
                return;
            }
            long size = this.deserializerSizeStream.getValue();
            this.deserializerSizeStream.reset();
            if (size == 0L) continue;
            if (size > Integer.MAX_VALUE) {
                Log.error((String)"Packet size too large: $size", (Object[])new Object[]{"socket", "nio client", "size", size});
                throw new IOException("Packet too large");
            }
            if ((long)b.getSizeForRead() < size) {
                Log.warn((String)"received incomplete packet body.", (Object[])new Object[]{"socket", "nio client", "expected", size, "available", b.getSizeForRead(), "channel", this.channel});
                return;
            }
            byte[] pkgBody = b.readBytes((int)size);
            try {
                this.localApiMeta.makeLocal((FastFutureContext)this, pkgBody, this.localApi);
            }
            catch (Exception e) {
                Log.error((String)"Error processing received NIO data: $error", (Throwable)e, (Object[])new Object[]{"socket", "nio client", "error", e.getMessage(), "channel", this.channel});
                throw new IOException("Data processing error", e);
            }
        }
    }

    private void writeToChannel(SelectionKey key) throws IOException {
        byte[] rawData;
        if (this.internalWriteBuffer.position() == 0 && (rawData = this.remoteDataToArray()).length > 0) {
            DataInOut sizeDataOut = new DataInOut();
            new SerializerPackNumber().put((DataOut)sizeDataOut, rawData.length);
            byte[] lengthBytes = sizeDataOut.toArray();
            int totalSize = lengthBytes.length + rawData.length;
            if (totalSize > this.internalWriteBuffer.capacity()) {
                Log.error((String)"Internal write buffer too small for packet of size: $totalSize", (Object[])new Object[]{"socket", "nio client", "totalSize", totalSize});
                throw new IllegalStateException("Internal write buffer too small for a single packet.");
            }
            this.internalWriteBuffer.clear();
            this.internalWriteBuffer.put(lengthBytes);
            this.internalWriteBuffer.put(rawData);
            this.internalWriteBuffer.flip();
        }
        if (this.internalWriteBuffer.hasRemaining()) {
            int n = this.channel.write(this.internalWriteBuffer);
        }
        if (!this.internalWriteBuffer.hasRemaining()) {
            this.internalWriteBuffer.clear();
            key.interestOps(1);
        } else {
            this.internalWriteBuffer.compact();
            this.internalWriteBuffer.flip();
        }
    }

    public void flush(AFuture sendFuture) {
        if (this.isEmpty()) {
            sendFuture.done();
            return;
        }
        if (this.channel.isOpen()) {
            try {
                this.key.interestOps(this.key.interestOps() | 4);
            }
            catch (CancelledKeyException e) {
                sendFuture.error((Throwable)new ClosedChannelException());
                return;
            }
            this.selector.wakeup();
            sendFuture.done();
        } else {
            sendFuture.error((Throwable)new ClosedChannelException());
        }
    }

    public AFuture close() {
        Log.info((String)"client initiated close on channel: $channel", (Object[])new Object[]{"socket", "nio client", "channel", this.channel});
        this.destroyChannel();
        return AFuture.completed();
    }

    private void destroyChannel() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                if (this.channel.isOpen()) {
                    this.channel.close();
                }
                this.selector.close();
            }
            catch (IOException e) {
                Log.error((String)"Error closing NIO client resources for: $channel", (Throwable)e, (Object[])new Object[]{"socket", "nio client", "channel", this.channel});
            }
        }
    }
}

