/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.fastMeta.nio;

import io.aether.logger.LNode;
import io.aether.logger.Log;
import io.aether.net.fastMeta.FastMetaApi;
import io.aether.net.fastMeta.FastMetaClient;
import io.aether.net.fastMeta.RemoteApi;
import io.aether.net.fastMeta.nio.FastApiContextClientNIO;
import io.aether.utils.RU;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.ARunnable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;

public class FastMetaClientNIO<LT, RT extends RemoteApi>
implements FastMetaClient<LT, RT> {
    private static final long RECONNECT_DELAY_MS = 500L;
    private static final long CONNECT_ATTEMPT_TIMEOUT_MS = 800L;
    private final AtomicReference<FastApiContextClientNIO<LT, RT>> currentContextRef = new AtomicReference();
    private final LNode logContext = Log.createContext();
    private final AtomicReference<ScheduledFuture<?>> connectAttemptFutureRef = new AtomicReference();
    private final ARFuture<FastApiContextClientNIO<LT, RT>> resultFuture = ARFuture.make();
    private URI uri;
    private FastMetaApi<LT, ?> localApiMeta;
    private FastMetaApi<?, RT> remoteApiMeta;
    private AFunction<RT, LT> localApi;

    public FastMetaClientNIO() {
        this.resultFuture.onCancel(() -> {
            Log.warn((String)"Connection cancelled via resultFuture for URI: $uri", (Object[])new Object[]{"uri", this.uri});
            this.destroy(true);
        });
    }

    public ARFuture<FastApiContextClientNIO<LT, RT>> connect(URI uri, FastMetaApi<LT, ?> localApiMeta, FastMetaApi<?, RT> remoteApiMeta, AFunction<RT, LT> localApi) {
        if (this.uri != null) {
            return ARFuture.doThrow((Throwable)new IllegalStateException("Client connection parameters were already set. Create a new client instance."));
        }
        this.uri = uri;
        this.localApiMeta = localApiMeta;
        this.remoteApiMeta = remoteApiMeta;
        this.localApi = localApi;
        if (this.resultFuture.isFinalStatus()) {
            return this.resultFuture;
        }
        this.scheduleConnectAttempt(0L);
        return this.resultFuture;
    }

    private void scheduleConnectAttempt(long delayMs) {
        if (this.resultFuture.isFinalStatus()) {
            return;
        }
        ARunnable connectionTask = Log.wrap(() -> {
            if (this.resultFuture.isFinalStatus()) {
                Log.debug((String)"Connection task aborted, result is final.", (Object[])new Object[]{"uri", this.uri});
                return;
            }
            FastApiContextClientNIO<LT, RT> existingContext = this.currentContextRef.get();
            if (existingContext != null) {
                if (existingContext.connectedFuture.isDone()) {
                    Log.info((String)"Found completed context during check. Finalizing.", (Object[])new Object[]{"uri", this.uri});
                    this.resultFuture.tryDone(existingContext);
                    return;
                }
                if (existingContext.connectedFuture.isError()) {
                    Log.warn((String)"Found stale context in error state. Clearing and retrying...", (Object[])new Object[]{"uri", this.uri});
                    this.currentContextRef.compareAndSet(existingContext, null);
                    existingContext.close();
                } else {
                    Log.debug((String)"Connection attempt already in progress. Waiting.", (Object[])new Object[]{"uri", this.uri});
                    this.scheduleConnectAttempt(500L);
                    return;
                }
            }
            SocketChannel channel = null;
            FastApiContextClientNIO<LT, RT> newContext = null;
            try {
                InetSocketAddress address = new InetSocketAddress(this.uri.getHost(), this.uri.getPort());
                Log.info((String)"Attempting connection to: $uri", (Object[])new Object[]{"socket", "nio client", "uri", this.uri, "address", address});
                channel = SocketChannel.open();
                channel.configureBlocking(false);
                channel.connect(address);
                newContext = new FastApiContextClientNIO<LT, RT>(channel, this.localApiMeta, this.remoteApiMeta, this.localApi, this.logContext);
                if (this.currentContextRef.compareAndSet(null, newContext)) {
                    this.setupContextListeners(newContext);
                } else {
                    Log.warn((String)"Connection race condition. Aborting redundant attempt.", (Object[])new Object[]{"uri", this.uri});
                    newContext.close();
                    this.scheduleConnectAttempt(500L);
                }
            }
            catch (IOException e) {
                String errorType = e.getClass().getSimpleName();
                Log.warn((String)"Synchronous connection setup failed with $errorType for URI: $uri. Retrying in $delayMs...", (Throwable)e, (Object[])new Object[]{"socket", "nio client", "uri", this.uri, "errorType", errorType, "delayMs", 500L});
                this.closeChannelQuietly(channel);
                this.currentContextRef.compareAndSet(newContext, null);
                this.scheduleConnectAttempt(500L);
            }
            catch (Exception e) {
                Log.warn((String)"Critical connection setup failed for URI: $uri. Retrying in $delayMs...", (Throwable)e, (Object[])new Object[]{"socket", "nio client", "uri", this.uri, "delayMs", 500L});
                this.closeChannelQuietly(channel);
                this.currentContextRef.compareAndSet(newContext, null);
                this.scheduleConnectAttempt(500L);
            }
        });
        ScheduledFuture newAttempt = RU.schedule((long)delayMs, (ARunnable)connectionTask);
        this.connectAttemptFutureRef.set(newAttempt);
    }

    private void setupContextListeners(FastApiContextClientNIO<LT, RT> context) {
        AFuture connectedFuture = context.connectedFuture;
        connectedFuture.addListener(Log.wrap(f -> {
            try {
                if (this.resultFuture.isFinalStatus()) {
                    return;
                }
                if (f.isDone()) {
                    Log.info((String)"Connection successful for URI: $uri", (Object[])new Object[]{"socket", "nio client", "uri", this.uri});
                    if (!this.resultFuture.tryDone((Object)context)) {
                        Log.warn((String)"Connection succeeded but resultFuture was already final. Closing context.", (Object[])new Object[]{"uri", this.uri});
                        context.close();
                    }
                } else if (f.isError()) {
                    Log.warn((String)"Asynchronous connection error for URI: $uri. Attempting reconnect...", (Throwable)f.getError(), (Object[])new Object[]{"socket", "nio client", "uri", this.uri});
                    this.currentContextRef.compareAndSet(context, null);
                    context.close();
                    this.scheduleConnectAttempt(500L);
                } else if (f.isCanceled()) {
                    Log.warn((String)"Connection context was cancelled internally for URI: $uri. Retrying...", (Object[])new Object[]{"socket", "nio client", "uri", this.uri});
                    this.currentContextRef.compareAndSet(context, null);
                    this.scheduleConnectAttempt(500L);
                }
            }
            catch (Exception e) {
                Log.warn((String)"CRITICAL: Failure inside connection listener. Retrying.", (Throwable)e, (Object[])new Object[]{"uri", this.uri});
                try {
                    this.currentContextRef.compareAndSet(context, null);
                    context.close();
                }
                finally {
                    if (!this.resultFuture.isFinalStatus()) {
                        this.scheduleConnectAttempt(500L);
                    }
                }
            }
        }));
        connectedFuture.timeoutMs(800L, () -> {
            if (this.resultFuture.isFinalStatus() || connectedFuture.isFinalStatus()) {
                return;
            }
            Log.warn((String)"Connection attempt timed out (stalled context) for URI: $uri. Retrying...", (Object[])new Object[]{"uri", this.uri});
            connectedFuture.error((Throwable)new RuntimeException("Connection context stalled (timeout 800ms)"));
        });
    }

    private void closeChannelQuietly(SocketChannel channel) {
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public AFuture destroy(boolean force) {
        FastApiContextClientNIO context;
        Log.info((String)"Destroying FastMetaClient (force=$force) for URI: $uri", (Object[])new Object[]{"force", force, "uri", this.uri});
        this.resultFuture.tryCancel();
        ScheduledFuture scheduledFuture = this.connectAttemptFutureRef.getAndSet(null);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(force);
        }
        if ((context = (FastApiContextClientNIO)this.currentContextRef.getAndSet(null)) == null) {
            Log.debug((String)"No active connection context to destroy.", (Object[])new Object[]{"uri", this.uri});
            return AFuture.completed();
        }
        Log.info((String)"Initiating context destruction (force=$force).", (Object[])new Object[]{"socket", "nio client", "force", force});
        return context.close();
    }
}

