/*
 * Decompiled with CFR 0.152.
 */
package io.aether.net.serialization;

import io.aether.net.fastMeta.AetherException;
import io.aether.utils.dataio.DataIn;

public class DeserializerSizeStream {
    private static final int u8 = 251;
    private static final int pow8_mask = 255;
    private static final int pow8_shift = 8;
    private static final int pow8 = 256;
    private static final int k8ReservedFor16 = 16;
    private static final int k16ReservedFor32 = 256;
    private static final long pow32 = 0x100000000L;
    private static final int u16 = 1515;
    private static final long u32 = 1049835L;
    private static final long u64 = 1099512677611L;
    private static final int pow16_mask = 65535;
    private static final int pow16_shift = 16;
    private static final int pow16 = 65536;
    private static final int pow32_shift = 32;
    private static final long pow32_mask = 0xFFFFFFFFL;
    private final DeserializerShort deserializerShort = new DeserializerShort();
    private final DeserializerInt deserializerInt = new DeserializerInt();
    private long val;
    private int state;

    public boolean put(DataIn in) {
        while (in.isReadable()) {
            switch (this.state) {
                case 0: {
                    this.val = in.readUByte();
                    if (this.val < 251L) {
                        return true;
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    int v = Byte.toUnsignedInt(in.readByte());
                    this.val = (this.val - 251L << 8) + 251L + (long)v;
                    if (this.val < 1515L) {
                        return true;
                    }
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (this.deserializerShort.put(in)) {
                        int f = Short.toUnsignedInt(this.deserializerShort.getValue());
                        this.val = (this.val - 1515L << 16) + 1515L + (long)f;
                        if (this.val < 1049835L) {
                            return true;
                        }
                        this.state = 3;
                        break;
                    }
                    return false;
                }
                case 3: {
                    if (this.deserializerInt.put(in)) {
                        long f1 = Integer.toUnsignedLong(this.deserializerInt.getValue());
                        this.val = (this.val - 1049835L << 32) + 1049835L + f1;
                        if (this.val < 1099512677611L) {
                            return true;
                        }
                        throw new AetherException();
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public void reset() {
        this.state = 0;
        this.val = 0L;
        this.deserializerInt.reset();
        this.deserializerShort.reset();
    }

    public long getValue() {
        return this.val;
    }

    private static class DeserializerInt {
        private int val;
        private int index;

        private DeserializerInt() {
        }

        public boolean put(DataIn in) {
            if (this.index == 0 && in.getSizeForRead() >= 4) {
                this.val = in.readInt();
                this.index = 0;
                return true;
            }
            while (this.index < 4 && in.isReadable()) {
                this.val |= Byte.toUnsignedInt(in.readByte()) << 8 * this.index;
                ++this.index;
            }
            return this.index == 4;
        }

        public void reset() {
            this.index = 0;
            this.val = 0;
        }

        public int getValue() {
            return this.val;
        }
    }

    private static class DeserializerShort {
        private short val;
        private int index;

        private DeserializerShort() {
        }

        public boolean put(DataIn in) {
            if (!in.isReadable()) {
                return false;
            }
            switch (this.index) {
                case 0: {
                    if (in.getSizeForRead() >= 2) {
                        this.val = in.readShort();
                        this.index = 2;
                        return true;
                    }
                    this.val = (short)in.readUByte();
                    this.index = 1;
                    return false;
                }
                case 1: {
                    this.val = (short)(this.val | (short)(in.readUByte() << 8));
                    this.index = 2;
                    return true;
                }
            }
            throw new RuntimeException();
        }

        public void reset() {
            this.index = 0;
            this.val = 0;
        }

        public short getValue() {
            return this.val;
        }
    }
}

