/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils;

import io.aether.utils.BCrypt;
import io.aether.utils.CharSequenceByArray;
import io.aether.utils.HexUtils;
import io.aether.utils.RU;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.CRC32;

public class WorkProofUtil {
    private static final int PASSWORD_SIZE = 72;
    private static final int SALT_SIZE = 64;
    private static final int SALT_SIZE2 = 64;
    private static final int INT32_LENGTH = String.valueOf(Integer.MAX_VALUE).length();

    public static int[] generateProofOfWorkPool(String salt, String suffix, int max_hash_val, int poolSize, long timeout) {
        CRC32 crc32 = new CRC32();
        char[] passwordBuf = new char[suffix.length() + 8];
        assert (passwordBuf.length <= 72) : passwordBuf.length + " > 72";
        CharSequenceByArray charsBuf = new CharSequenceByArray(passwordBuf);
        char[] suffixBuf = suffix.toCharArray();
        System.arraycopy(suffixBuf, 0, passwordBuf, 8, suffixBuf.length);
        int[] result = new int[poolSize];
        long startTime = RU.time();
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        StringBuilder temp2 = new StringBuilder();
        int prefix = 0;
        for (int e = 0; e < poolSize; ++e) {
            while (true) {
                HexUtils.toHexString((int)prefix, (char[])passwordBuf, (int)0);
                if (WorkProofUtil.checkProofOfWorkHash(salt, (CharSequence)charsBuf, max_hash_val, crc32, temp, temp2)) break;
                ++prefix;
            }
            result[e] = prefix++;
        }
        return result;
    }

    public static boolean checkProofOfWorkHashList(String salt, String suffix, int[] passwords, int max_hash_val) {
        CRC32 crc32 = new CRC32();
        char[] passwordBuf = new char[suffix.length() + 8];
        assert (passwordBuf.length <= 72) : passwordBuf.length + " > 72";
        char[] suffixBuf = suffix.toCharArray();
        System.arraycopy(suffixBuf, 0, passwordBuf, 8, suffixBuf.length);
        CharSequenceByArray charsBuf = new CharSequenceByArray(passwordBuf);
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        StringBuilder temp2 = new StringBuilder();
        for (int p : passwords) {
            HexUtils.toHexString((int)p, (char[])charsBuf.data, (int)0);
            if (WorkProofUtil.checkProofOfWorkHash(salt, (CharSequence)charsBuf, max_hash_val, crc32, temp, temp2)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkProofOfWorkHash(String salt, CharSequence password, int max_hash_val, CRC32 crc32, ByteArrayOutputStream temp, StringBuilder temp2) {
        String hash = BCrypt.hashpw((CharSequence)password, (CharSequence)salt, (ByteArrayOutputStream)temp, (StringBuilder)temp2);
        crc32.reset();
        crc32.update(hash.getBytes(StandardCharsets.US_ASCII));
        return Math.abs((int)crc32.getValue()) <= max_hash_val;
    }
}

