/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.consoleCanonical;

import io.aether.logger.Log;
import io.aether.logger.LogFilter;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMeta;
import io.aether.utils.AString;
import io.aether.utils.CTypeI;
import io.aether.utils.Mods;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.flow.Flow;
import io.aether.utils.futures.AFuture;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.interfaces.ABiFunction;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.slots.EventConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class ConsoleMgrCanonical {
    final Map<String, Boolean> flags = new ConcurrentHashMap<String, Boolean>();
    final Map<String, String> vals = new ConcurrentHashMap<String, String>();
    private final Map<CTypeI<?>, AFunction<String, Object>> converters = new ConcurrentHashMap();
    private final Map<String, Map<CTypeI<?>, ABiFunction<ResCtx, Object, byte[]>>> resultConverters = new ConcurrentHashMap();
    public String footer;
    List<String> args;
    List<String> argsOrigin;
    boolean helpMode;
    InputStream stdin = System.in;
    Object rootApi;
    private ARFuture<Object> executionResultFuture;

    public ConsoleMgrCanonical(String ... args) {
        this.args = new ObjectArrayList((Object[])args);
        if (this.args.isEmpty()) {
            this.args.add("help");
        }
        this.argsOrigin = new ObjectArrayList((Object[])args);
        this.regConverter(CTypeI.of(UUID.class), (AFunction<String, Object>)((AFunction)UUID::fromString));
        this.regConverter(CTypeI.of(File.class), (AFunction<String, Object>)((AFunction)File::new));
        this.regConverter(CTypeI.of(Integer.TYPE), (AFunction<String, Object>)((AFunction)Integer::parseInt));
        this.regConverter(CTypeI.of(Long.TYPE), (AFunction<String, Object>)((AFunction)Long::parseLong));
        this.regConverter(CTypeI.of(Short.TYPE), (AFunction<String, Object>)((AFunction)Short::parseShort));
        this.regConverter(CTypeI.of(Byte.TYPE), (AFunction<String, Object>)((AFunction)Byte::parseByte));
        this.regConverter(CTypeI.of(Float.TYPE), (AFunction<String, Object>)((AFunction)Float::parseFloat));
        this.regConverter(CTypeI.of(Double.TYPE), (AFunction<String, Object>)((AFunction)Double::parseDouble));
        this.regConverter(CTypeI.of(URI.class), (AFunction<String, Object>)((AFunction)URI::create));
        this.regConverter(CTypeI.BOOLEAN, (AFunction<String, Object>)((AFunction)Boolean::parseBoolean));
        this.regResultConverter("bin", CTypeI.of(UUID.class), v -> {
            if (v == null) {
                return null;
            }
            DataInOut out = new DataInOut();
            FastMeta.META_UUID.serialize(FastFutureContext.STUB, v, (DataOut)out);
            return out.toArray();
        });
        this.regResultConverter("json", CTypeI.of(UUID.class), v -> {
            if (v == null) {
                return null;
            }
            return ("\"" + String.valueOf(v) + "\"").getBytes(StandardCharsets.UTF_8);
        });
        this.regResultConverter("json", CTypeI.STRING, v -> {
            if (v == null) {
                return null;
            }
            return ("\"" + v + "\"").getBytes(StandardCharsets.UTF_8);
        });
    }

    public <T> void regResultConverter(String format, CTypeI<T> type, AFunction<T, byte[]> f) {
        this.regResultConverterCtx(format, type, (c, v) -> (byte[])f.apply(RU.cast((Object)v)));
    }

    public <T> void regResultConverterCtx(String format, CTypeI<T> type, ABiFunction<ResCtx, T, byte[]> f) {
        this.resultConverters.computeIfAbsent(format, k -> new ConcurrentHashMap()).put(type, (ABiFunction)RU.cast(f));
    }

    String getByKey(String key) {
        if (this.vals.containsKey(key = key.toLowerCase()) && this.vals.get(key) == null) {
            return null;
        }
        return this.vals.computeIfAbsent(key, kk -> {
            String key2 = "--" + kk.toLowerCase();
            String key3 = "--" + kk.toLowerCase() + "=";
            Iterator<String> it = this.args.iterator();
            while (it.hasNext()) {
                String k = it.next().toLowerCase();
                if (k.equals(key2)) {
                    if (!it.hasNext()) {
                        throw new UnsupportedOperationException("Value not set for key: " + key2);
                    }
                    it.remove();
                    String r = it.next();
                    it.remove();
                    return r;
                }
                if (!k.startsWith(key3)) continue;
                it.remove();
                return k.split("=")[1];
            }
            return null;
        });
    }

    boolean getFlag(String flag) {
        return this.flags.computeIfAbsent(flag.toLowerCase(), key -> {
            String key2 = "--" + key.toLowerCase();
            Iterator<String> it = this.args.iterator();
            while (it.hasNext()) {
                String k = it.next().toLowerCase();
                if (!k.equals(key2)) continue;
                it.remove();
                return true;
            }
            return false;
        });
    }

    public void regConverter(CTypeI<?> type, AFunction<String, Object> f) {
        this.converters.put(type, f);
    }

    public Object convert(CTypeI<?> type, String s) {
        if (type.instanceOf(String.class)) {
            return s;
        }
        AFunction f = this.converters.get(type);
        if (f == null) {
            if (type.isEnum()) {
                f = v -> Enum.valueOf((Class)RU.cast((Object)type.getRaw()), v);
                this.converters.put(type, (AFunction<String, Object>)f);
                return f;
            }
            if (type.instanceOf(Collection.class)) {
                CTypeI c = type.getComponent();
                f = v -> {
                    ObjectArrayList res;
                    String[] vv = v.split("(?<=[^\\\\]),");
                    if (type.instanceOf(List.class)) {
                        res = new ObjectArrayList();
                    } else if (type.instanceOf(Set.class)) {
                        res = new ObjectOpenHashSet();
                    } else {
                        throw new UnsupportedOperationException();
                    }
                    for (String e : vv) {
                        res.add(RU.cast((Object)this.convert(c, e)));
                    }
                    return RU.cast((Object)res);
                };
                this.converters.put(type, (AFunction<String, Object>)f);
                return f;
            }
            if (type.isArray()) {
                CTypeI c = type.getComponent();
                f = v -> {
                    String[] vv = v.split(",");
                    Object res = Array.newInstance(c.getRaw2(), vv.length);
                    int i = 0;
                    for (String e : vv) {
                        Array.set(res, i++, this.convert(c, e));
                    }
                    return RU.cast((Object)res);
                };
                this.converters.put(type, (AFunction<String, Object>)f);
                return f;
            }
            throw new IllegalStateException("converter not found for " + String.valueOf(type));
        }
        return f.apply((Object)s);
    }

    String convertMethodName(String s) {
        StringBuilder sb = new StringBuilder();
        boolean flag = true;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (flag) {
                if (Character.isUpperCase(ch) || Character.isDigit(ch)) {
                    sb.append(Character.toLowerCase(ch));
                    continue;
                }
                flag = false;
                sb.append(ch);
                continue;
            }
            if (Character.isUpperCase(ch) || Character.isDigit(ch)) {
                sb.append("-");
                sb.append(Character.toLowerCase(ch));
                flag = true;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    String buildHelpForMethod(CTypeI<?> owner, Method m) {
        Example[] examples;
        AString s = AString.of();
        s.add("Method: ");
        if (m.isAnnotationPresent(Alias.class)) {
            s.add(m.getAnnotation(Alias.class).value()).add(", ");
        }
        s.add(this.convertMethodName(m.getName())).add("\n");
        Doc d = m.getAnnotation(Doc.class);
        if (d != null) {
            s.add(d.value()).add("\n");
        }
        for (Example ex : examples = (Example[])m.getAnnotationsByType(Example.class)) {
            s.styleForeground(AString.Style.BRIGHT, 150, 255, 150).add(this.buildExampleString(ex.value())).styleClear();
        }
        Parameter[] parameters = m.getParameters();
        CTypeI[] pt = owner.resolveTypeArgs(m);
        s.add("\n");
        boolean withTypes = this.getFlag("with-types");
        for (int i = 0; i < parameters.length; ++i) {
            Example[] paramExamples;
            Parameter p = parameters[i];
            int len = s.length();
            s.addSpace(4);
            Optional option = p.getAnnotation(Optional.class);
            if (p.isAnnotationPresent(StdIn.class)) {
                s.add("#");
            }
            if (option != null) {
                s.style(AString.Style.DIM).add("[");
            } else {
                s.add("<");
            }
            Alias alias = p.getAnnotation(Alias.class);
            if (alias != null) {
                if (option != null) {
                    s.add("--");
                }
                s.add(alias.value());
                if (option != null) {
                    s.add("|");
                }
            }
            if (option != null) {
                s.add("--");
            }
            if (option != null || alias == null) {
                s.add(this.convertMethodName(p.getName()));
            }
            if (withTypes) {
                s.style(AString.Style.DIM);
                s.add(":").add((ToString)pt[i]);
                s.styleClear();
            }
            if (option != null) {
                if (!option.value().isEmpty()) {
                    s.color(AString.Color.GREEN).add(" (").add(option.value()).add(")").styleClear();
                }
                s.add("]").styleClear();
            } else {
                s.add(">");
            }
            int lenD = s.calcVisibleSymbols(len);
            Doc dd = p.getAnnotation(Doc.class);
            if (dd != null) {
                s.addWithAlign(70, lenD, 30, dd.value());
            }
            if ((paramExamples = (Example[])p.getAnnotationsByType(Example.class)).length > 0) {
                for (Example example : paramExamples) {
                    s.styleForeground(AString.Style.BRIGHT, 150, 255, 150).addWithAlign(70, dd == null ? lenD : 0, 30, this.buildExampleString(example.value())).styleClear();
                }
            }
            if (dd == null && paramExamples.length == 0) {
                s.add("\n");
            }
            if (pt[i].isEnum()) {
                s.style(AString.Style.ITALIC).addSpace(4).add("Possible values: ").add(Flow.flow((Object[])pt[i].getEnumValues()).map(v -> AString.of().style(AString.Style.BRIGHT).style(AString.Style.ITALIC).add(v).styleClear()).join(", ")).styleClear().add("\n");
            }
            if (p.isAnnotationPresent(StdIn.class)) {
                s.style(AString.Style.ITALIC).addSpace(4).add("The argument can accept data from standard input\n").styleClear();
            }
            s.add("\n");
        }
        this.addRequiredHelp(s);
        return s.toString();
    }

    public ARFuture<Object> execute(CTypeI<?> type, Object api, Method m) {
        CTypeI finalRt;
        CTypeI rt2;
        Object res;
        String a;
        this.executionResultFuture = ARFuture.make();
        CTypeI rt = type.resolveReturnType(m);
        String fileOutFormat = this.getByKey("file-out-format");
        String fileOut = this.getByKey("file-out");
        String consoleFormat = this.getByKey("console");
        String fileAppend = this.getByKey("file-out-append");
        if (this.helpMode) {
            if (m.isAnnotationPresent(Api.class)) {
                return this.execute(rt, null);
            }
            this.result(CTypeI.STRING, this.buildHelpForMethod(type, m), fileOut, fileOutFormat, consoleFormat, fileAppend);
            this.executionResultFuture.tryDone(null);
            return this.executionResultFuture;
        }
        Object[] aa = new Object[m.getParameterCount()];
        CTypeI[] pt = type.resolveTypeArgs(m);
        int ia = 0;
        while (ia < this.args.size() && (a = this.args.get(ia)).startsWith("--")) {
            if (a.matches("--\\w+=.*")) {
                ++ia;
                continue;
            }
            ia += 2;
        }
        for (int i = 0; i < aa.length; ++i) {
            String val;
            Parameter p = m.getParameters()[i];
            Alias alias = p.getAnnotation(Alias.class);
            String pn1 = this.convertMethodName(p.getName());
            String pn2 = alias == null ? null : alias.value();
            Optional optional = p.getAnnotation(Optional.class);
            if (optional == null) {
                if (this.getFlag("stdin") && p.isAnnotationPresent(StdIn.class)) {
                    try {
                        val = new String(this.stdin.readAllBytes());
                    }
                    catch (IOException e) {
                        RU.error((Throwable)e);
                        this.executionResultFuture.error((Throwable)e);
                        return this.executionResultFuture;
                    }
                } else {
                    val = this.args.remove(ia);
                }
                if (val == null) {
                    IllegalStateException ex = new IllegalStateException("Value is not specified for: " + this.convertMethodName(p.getName()));
                    this.executionResultFuture.error((Throwable)ex);
                    return this.executionResultFuture;
                }
                aa[i] = this.convert(pt[i], val);
                continue;
            }
            val = pt[i].getRaw2() == Boolean.TYPE || pt[i].getRaw2() == Boolean.class ? String.valueOf(this.getFlag(pn1)) : this.getByKey(pn1);
            if (val == null && pn2 != null) {
                val = pt[i].getRaw2() == Boolean.TYPE || pt[i].getRaw2() == Boolean.class ? AString.of().add(this.getFlag(pn2)).toString() : this.getByKey(pn2);
            }
            if (val == null && !optional.value().isEmpty()) {
                val = optional.value();
            }
            if (val == null && p.isAnnotationPresent(StdIn.class)) {
                try {
                    val = new String(this.stdin.readAllBytes());
                }
                catch (IOException e) {
                    RU.error((Throwable)e);
                    this.executionResultFuture.error((Throwable)e);
                    return this.executionResultFuture;
                }
            }
            if (Objects.equals(pn1, "file-out") || Objects.equals(pn2, "file-out")) {
                fileOut = val;
            }
            if (Objects.equals(pn1, "file-out-format") || Objects.equals(pn2, "file-out-format")) {
                fileOutFormat = val;
            }
            if (Objects.equals(pn1, "console") || Objects.equals(pn2, "console")) {
                consoleFormat = val;
            }
            if (Objects.equals(pn1, "file-out-append") || Objects.equals(pn2, "file-out-append")) {
                fileAppend = val;
            }
            if (val == null) continue;
            aa[i] = this.convert(pt[i], val);
        }
        String fileOutFinal = fileOut;
        String fileOutFormatFinal = fileOutFormat;
        String consoleFormatFinal = consoleFormat;
        String fileAppendFinal = fileAppend;
        try {
            res = m.invoke(api, aa);
        }
        catch (InvocationTargetException e) {
            e.getCause().printStackTrace();
            this.executionResultFuture.error(e.getCause());
            return this.executionResultFuture;
        }
        catch (Exception e) {
            this.executionResultFuture.error((Throwable)e);
            return this.executionResultFuture;
        }
        if (res != null && (rt2 = CTypeI.of(res.getClass())).instanceOf(rt)) {
            rt = rt2;
        }
        if (rt.instanceOf(Void.TYPE)) {
            this.executionResultFuture.tryDone(null);
        } else if (rt.instanceOf(AFuture.class)) {
            ((AFuture)((AFuture)RU.cast((Object)res)).to(() -> this.executionResultFuture.tryDone(null))).onError(arg_0 -> this.executionResultFuture.error(arg_0));
        } else if (rt.instanceOf(EventConsumer.class)) {
            finalRt = rt;
            ((EventConsumer)RU.cast((Object)res)).add(v -> {
                CTypeI rt2;
                CTypeI c = finalRt.getComponent();
                if (c == null) {
                    c = CTypeI.of(Object.class);
                }
                if (v != null && (rt2 = CTypeI.of(v.getClass())).instanceOf(c)) {
                    c = (CTypeI)RU.cast((Object)rt2);
                }
                if (m.isAnnotationPresent(Api.class)) {
                    this.execute(c, v).to(this.executionResultFuture);
                } else {
                    this.result(c, v, fileOutFinal, fileOutFormatFinal, consoleFormatFinal, fileAppendFinal);
                    this.executionResultFuture.tryDone(v);
                }
            });
        } else if (rt.instanceOf(ARFuture.class)) {
            finalRt = rt;
            ((ARFuture)RU.cast((Object)res)).to(v -> {
                CTypeI rt2;
                CTypeI c = finalRt.getComponent();
                if (c == null) {
                    c = CTypeI.of(Object.class);
                }
                if (v != null && (rt2 = CTypeI.of(v.getClass())).instanceOf(c)) {
                    c = (CTypeI)RU.cast((Object)rt2);
                }
                if (m.isAnnotationPresent(Api.class)) {
                    this.execute(c, v).to(this.executionResultFuture);
                } else {
                    this.result(c, v, fileOutFinal, fileOutFormatFinal, consoleFormatFinal, fileAppendFinal);
                    this.executionResultFuture.tryDone(v);
                }
            }).onError(arg_0 -> this.executionResultFuture.error(arg_0));
        } else if (m.isAnnotationPresent(Api.class)) {
            this.execute(rt, res).to(this.executionResultFuture);
        } else {
            this.result(rt, res, fileOut, fileOutFormat, consoleFormat, fileAppend);
            this.executionResultFuture.tryDone(res);
        }
        return this.executionResultFuture;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void result(CTypeI<?> type, Object val, String fileOutStr, String fileOutFormatStr, String consoleFormatStr, String fileAppend) {
        Map<CTypeI<?>, ABiFunction<ResCtx, Object, byte[]>> fomatMap;
        fileOutFormatStr = fileOutFormatStr == null ? "human" : fileOutFormatStr.toLowerCase();
        ResCtx ctx = new ResCtx();
        if (fileAppend != null) {
            ctx.append = Boolean.parseBoolean(fileAppend);
        }
        if (fileOutStr != null) {
            byte[] data;
            File f = new File(fileOutStr);
            Map<CTypeI<?>, ABiFunction<ResCtx, Object, byte[]>> fomatMap2 = this.resultConverters.get(fileOutFormatStr);
            if (fomatMap2 == null || fomatMap2.get(type) == null) {
                if (!fileOutFormatStr.equals("human")) throw new UnsupportedOperationException("unsupported format [" + fileOutFormatStr + "] for: " + String.valueOf(val));
                data = AString.of().add(val).getBytes();
            } else {
                ABiFunction<ResCtx, Object, byte[]> ff = fomatMap2.get(type);
                data = (byte[])ff.apply((Object)ctx, val);
                if (ctx.fileName != null) {
                    f = new File(fileOutStr + "-" + ctx.fileName);
                }
            }
            try {
                OpenOption[] openOptionArray = new OpenOption[1];
                openOptionArray[0] = f.exists() ? (this.getFlag("file-out-append") ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING) : StandardOpenOption.CREATE;
                Files.write(Paths.get(f.toURI()), data, openOptionArray);
            }
            catch (Exception e) {
                RU.error((Throwable)e);
            }
        }
        if (consoleFormatStr == null) {
            consoleFormatStr = "human";
        }
        if ((fomatMap = this.resultConverters.get(consoleFormatStr)) == null || fomatMap.get(type) == null) {
            if (!consoleFormatStr.equals("human")) throw new UnsupportedOperationException("unsupported format [" + fileOutFormatStr + "] for: " + String.valueOf(val));
            System.out.println(AString.of().add(val));
            return;
        }
        byte[] data = (byte[])fomatMap.get(type).apply((Object)ctx, val);
        try {
            System.out.write(data);
            System.out.flush();
            return;
        }
        catch (IOException e) {
            RU.error((Throwable)e);
        }
    }

    public String getAppName() {
        return "app";
    }

    public ARFuture<Object> execute(Object api) {
        if (this.getFlag("loggerConsole")) {
            Log.printConsoleColored((LogFilter)new LogFilter());
        }
        if (this.rootApi == null) {
            this.rootApi = api;
        }
        return this.execute(CTypeI.of(api.getClass()), api);
    }

    private Flow<Method> getMethods(CTypeI<?> type) {
        return type.getAllMethods().filter(Mods::isPublic).filter(m -> m.getDeclaringClass() != Object.class);
    }

    private void printHelpApi(CTypeI<?> type) {
        AString s = AString.of();
        s.style(AString.Style.BRIGHT, AString.Color.ORANGE);
        s.add("List methods ");
        s.add(type.getRawSimpleName());
        s.add("\n");
        Doc d = (Doc)type.getAnnotation(Doc.class);
        if (d != null) {
            s.add(d.value()).add("\n\n");
        }
        s.styleClear();
        boolean withTypes = this.getFlag("with-types");
        for (Method m : this.getMethods(type)) {
            Example[] examples;
            int len = s.length();
            s.add("<");
            String cmdName = this.convertMethodName(m.getName());
            s.add(cmdName);
            Alias alias = m.getAnnotation(Alias.class);
            if (alias != null) {
                s.add("|").add(alias.value());
            }
            s.add(">");
            AString s1 = AString.of();
            AString s2 = AString.of();
            Parameter[] parameters = m.getParameters();
            CTypeI[] pt = type.resolveTypeArgs(m);
            for (int i = 0; i < parameters.length; ++i) {
                Parameter p = parameters[i];
                Optional option = p.getAnnotation(Optional.class);
                AString ss = option == null ? s1 : s2;
                ss.add(" ");
                Alias aliasParam = p.getAnnotation(Alias.class);
                if (option == null) {
                    ss.add("<");
                    if (aliasParam == null) {
                        ss.add(this.convertMethodName(p.getName()));
                    } else {
                        ss.add(aliasParam.value());
                    }
                    if (withTypes) {
                        ss.style(AString.Style.DIM);
                        ss.add(":");
                        pt[i].getRawSimpleNameWithParameters(ss);
                        ss.styleClear();
                    }
                    ss.add(">");
                    continue;
                }
                ss.style(AString.Style.DIM);
                ss.add("[");
                ss.add("--");
                ss.add(this.convertMethodName(p.getName()));
                if (aliasParam != null) {
                    ss.add("|--");
                    ss.add(aliasParam.value());
                }
                if (!option.value().isBlank()) {
                    ss.color(AString.Color.GREEN).add(" (").add(option.value()).add(")").styleClear().style(AString.Style.DIM);
                }
                if (withTypes) {
                    ss.add(":");
                    pt[i].getRawSimpleNameWithParameters(ss);
                }
                ss.add("]");
                ss.style(AString.Style.CLEAR);
            }
            s.add((CharSequence)s1).add((CharSequence)s2);
            Doc doc = m.getAnnotation(Doc.class);
            int lend = s.calcVisibleSymbols(len);
            if (doc != null) {
                s.styleForeground(AString.Style.ITALIC, 250, 250, 250).addWithAlign(70, lend, 60, doc.value()).styleClear();
                lend = 0;
            }
            for (Example example : examples = (Example[])m.getAnnotationsByType(Example.class)) {
                s.styleForeground(AString.Style.BRIGHT, 150, 255, 150).addWithAlign(70, lend, 60, this.buildExampleString(example.value())).styleClear();
                lend = 0;
            }
            if (m.isAnnotationPresent(Api.class)) {
                s.addWithAlign(70, lend, 60, AString.of().add("To view details, see ").style(AString.Style.BRIGHT).add(this.getAppName()).add(" help " + Flow.flow(this.args).filterNot(a -> a.startsWith("--")).join(" ") + " " + cmdName).styleClear().toString());
            } else if (doc == null && examples.length == 0) {
                s.add("\n");
            }
            s.repeat(150, "\u23bc").add("\n");
        }
        this.addRequiredHelp(s);
        this.result(CTypeI.STRING, s.toString(), this.getByKey("file-out"), this.getByKey("file-out-format"), this.getByKey("console"), this.getByKey("file-out-append"));
    }

    public ARFuture<Object> execute(CTypeI<?> type, Object api) {
        String a;
        this.executionResultFuture = ARFuture.make();
        int argIndex = 0;
        while (argIndex < this.args.size() && (a = this.args.get(argIndex)).startsWith("--")) {
            if (a.matches("--\\w+=.*")) {
                ++argIndex;
                continue;
            }
            argIndex += 2;
        }
        if (argIndex >= this.args.size()) {
            if (this.helpMode) {
                this.printHelpApi(type);
                this.executionResultFuture.tryDone(null);
            } else {
                System.err.println("Method is not specified: " + String.valueOf(AString.of().add(this.args)));
                this.showHelp();
                this.executionResultFuture.tryDone(null);
            }
            return this.executionResultFuture;
        }
        a = this.args.get(argIndex).toLowerCase();
        if (a.equals("help")) {
            this.helpMode = true;
            this.args.remove(a);
            this.execute(type, api).to(this.executionResultFuture);
        } else {
            for (Method m : this.getMethods(type)) {
                String alias;
                Alias aliasAnnotation = m.getAnnotation(Alias.class);
                String string = alias = aliasAnnotation == null ? null : aliasAnnotation.value();
                if (!this.convertMethodName(m.getName()).equals(a) && (alias == null || !alias.equals(a))) continue;
                this.args.remove(a);
                this.execute(type, api, m).to(this.executionResultFuture);
                return this.executionResultFuture;
            }
            if (this.helpMode) {
                this.printHelpApi(type);
                this.executionResultFuture.tryDone(null);
            } else {
                System.out.println("Method is not found: " + String.valueOf(AString.of().add(this.args)));
                this.argsOrigin.remove(a);
                this.showHelp();
                this.executionResultFuture.tryDone(null);
            }
        }
        return this.executionResultFuture;
    }

    private void showHelp() {
        this.helpMode = true;
        this.args = new ObjectArrayList(this.argsOrigin);
        this.execute(this.rootApi);
    }

    private void addRequiredHelp(AString s) {
        s.add("\n");
        s.add("The options are available for all commands and allow you to specify the output format for the command execution.\n");
        s.style(AString.Style.BRIGHT);
        s.add("--console <format>\n");
        s.add("--file-out <file-name>\n");
        s.add("--file-out-append <true|false>\n");
        s.add("--file-out-format <format>\n\n");
        s.add("--loggerConsole\n\n");
        s.styleClear();
        s.add("Possible values for the format: ").style(AString.Style.BRIGHT).add("human").styleClear().add(", ").style(AString.Style.BRIGHT).add("json").styleClear().add(", ").style(AString.Style.BRIGHT).add("bin").styleClear().add("\n");
        s.add("if the command supports an additional output format, this will be indicated in the help information.\n\n");
        s.add("If the argument is marked with the ").style(AString.Style.BRIGHT).add("#").styleClear().add(" symbol in the help information, you can use the ").style(AString.Style.BRIGHT).add("--stdin").styleClear().add(" option to specify the need to read the argument value from the standard input.\n");
        s.add("Use the ").style(AString.Style.BRIGHT).add("--with-types").styleClear().add(" option to display the background information with the types of arguments.");
        s.add("\n");
        if (this.footer != null) {
            s.add(this.footer);
        }
    }

    private String buildExampleString(String s) {
        AString ss = AString.of();
        ss.add("Example: ").addVars((CharSequence)s, c -> {
            switch (c.toString()) {
                case "exCmd": {
                    return this.getAppName();
                }
            }
            return "???";
        });
        return ss.toString();
    }

    public void setStd(ByteArrayInputStream stdin) {
        this.stdin = stdin;
    }

    public class ResCtx {
        String fileName;
        StandardOpenOption fileMode;
        boolean toFile;
        boolean append;

        public void setFileModeAppend(boolean f) {
            this.fileMode = f ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING;
        }

        public boolean isAppend() {
            return this.append;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String name) {
            this.fileName = name;
        }

        public boolean isToFile() {
            return this.toFile;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Api {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ResultFormats {
        public String[] value() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StdIn {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Optional {
        public String value() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Alias {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE, ElementType.FIELD})
    public static @interface Examples {
        public Example[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=Examples.class)
    public static @interface Example {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Doc {
        public String value();
    }
}

