/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.net.fastMeta.SerializerPackNumber;
import io.aether.net.serialization.DeserializerSizeStream;
import io.aether.utils.AString;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.streams.FGate;
import io.aether.utils.streams.Gate;
import io.aether.utils.streams.Node;
import io.aether.utils.streams.Value;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class Accumulator
implements Node<byte[], byte[], byte[], byte[]> {
    private final FGate<byte[], byte[]> up = FGate.of(new AccUp(this));
    private final FGate<byte[], byte[]> down = FGate.of(new AccDown(this));
    volatile DataInOutStatic pkg;

    public void toString(AString sb) {
        DataInOutStatic p = this.pkg;
        if (p == null) {
            sb.add("Accumulator(void)");
        } else {
            sb.add("Accumulator(").add(p.total()).add(":").add(p.getSizeForWrite()).add(")");
        }
    }

    public String toString() {
        return this.toString2();
    }

    @Override
    public FGate<byte[], byte[]> gDown() {
        return this.down;
    }

    @Override
    public FGate<byte[], byte[]> gUp() {
        return this.up;
    }

    public static Gate<byte[], byte[]> of(Gate<byte[], byte[]> down) {
        Accumulator ac = new Accumulator();
        ac.down().link(down);
        return ac.up.outSide();
    }

    class AccDown
    extends FGate.Pair<byte[], byte[], byte[]> {
        final DeserializerSizeStream deserializerSizeStream;
        private volatile Collection<Value<?>> values;

        public AccDown(Object owner) {
            super(owner);
            this.deserializerSizeStream = new DeserializerSizeStream();
        }

        @Override
        @NotNull
        public FGate.InsideGate pair() {
            return Accumulator.this.up.inSide;
        }

        @Override
        public void send(FGate<byte[], byte[]> fGate, Value<byte[]> value) {
            value.enter(Accumulator.this);
            if (value.isOnlyRequestData()) {
                Accumulator.this.gUp().inSide.send(value);
                return;
            }
            assert (!value.isRequestData());
            if (value.isData()) {
                DataInOutStatic b = new DataInOutStatic(value.data());
                if (this.values == null) {
                    this.values = new ConcurrentHashSet();
                }
                this.values.add(value);
                while (b.isReadable()) {
                    if (Accumulator.this.pkg == null) {
                        if (!this.deserializerSizeStream.put((DataIn)b)) {
                            return;
                        }
                        int size = (int)this.deserializerSizeStream.getValue();
                        assert (size != 0);
                        Accumulator.this.pkg = new DataInOutStatic(new byte[size], 0, 0);
                        this.deserializerSizeStream.reset();
                    }
                    if (b.isReadable() && b.getSizeForRead() >= Accumulator.this.pkg.getSizeForWrite()) {
                        b.read(Accumulator.this.pkg.data, Accumulator.this.pkg.writePos, Accumulator.this.pkg.getSizeForWrite());
                        Accumulator.this.pkg.writePos = Accumulator.this.pkg.data.length;
                        DataInOutStatic p = Accumulator.this.pkg;
                        Collection<Value<?>> vv = this.values;
                        this.values = null;
                        Accumulator.this.pkg = null;
                        byte[] arr = p.toArray();
                        if (vv == null) {
                            this.pair().send(Value.of(arr));
                            continue;
                        }
                        this.pair().send(Value.of(arr, false, vv));
                        continue;
                    }
                    int s = b.getSizeForRead();
                    b.read(Accumulator.this.pkg.data, Accumulator.this.pkg.writePos, s);
                    Accumulator.this.pkg.writePos += s;
                }
            } else if (value.isForce() || value.isClose()) {
                Accumulator.this.gUp().inSide.send(value);
            }
        }
    }

    class AccUp
    extends FGate.Pair<byte[], byte[], byte[]> {
        public AccUp(Object owner) {
            super(owner);
        }

        @Override
        public @NotNull FGate.InsideGate pair() {
            return Accumulator.this.down.inSide;
        }

        byte[] convert(byte[] value) {
            DataInOutStatic b = new DataInOutStatic(value);
            int sizeHead = SerializerPackNumber.INSTANCE.calcSize((long)b.getSizeForRead());
            byte[] buf = new byte[sizeHead + b.getSizeForRead()];
            DataInOutStatic bb = new DataInOutStatic(buf);
            bb.setWritePos(0);
            SerializerPackNumber.INSTANCE.put((DataOut)bb, b.getSizeForRead());
            b.read(buf, sizeHead, b.getSizeForRead());
            return buf;
        }

        @Override
        public void send(FGate<byte[], byte[]> fGate, Value<byte[]> value) {
            value.enter(Accumulator.this);
            if (value.isData()) {
                if (value.data().length == 0) {
                    throw new IllegalStateException();
                }
                this.pair().send(value.map(this::convert));
            } else {
                this.pair().send(value);
            }
        }
    }
}

