/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.logger.Log;
import io.aether.net.fastMeta.FastFutureContext;
import io.aether.net.fastMeta.FastMetaType;
import io.aether.utils.AString;
import io.aether.utils.CTypeI;
import io.aether.utils.ConcurrentHashSet;
import io.aether.utils.RU;
import io.aether.utils.dataio.DataIn;
import io.aether.utils.dataio.DataInOut;
import io.aether.utils.dataio.DataInOutStatic;
import io.aether.utils.dataio.DataOut;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.interfaces.ABiConsumer;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.interfaces.APredicate;
import io.aether.utils.streams.AcceptorI;
import io.aether.utils.streams.BufferNode;
import io.aether.utils.streams.BufferNodeAutoFlush;
import io.aether.utils.streams.FGate;
import io.aether.utils.streams.GateI;
import io.aether.utils.streams.NodeConverter;
import io.aether.utils.streams.NodeConverterAsync;
import io.aether.utils.streams.NodeFilter;
import io.aether.utils.streams.OfBiConsumer;
import io.aether.utils.streams.OfConsumer;
import io.aether.utils.streams.OfConsumerValue;
import io.aether.utils.streams.Value;
import java.util.Arrays;
import java.util.Queue;
import java.util.Set;

public interface Gate<TWrite, TRead>
extends GateI<TWrite> {
    default public <LT, RT> Gate<LT, RT> map(final FastMetaType<LT> metaLt, final FastMetaType<RT> metaRt) {
        NodeConverter res = new NodeConverter<byte[], byte[], LT, RT>(){

            public void toString(AString sb) {
                sb.add("(" + String.valueOf(metaLt) + ":" + String.valueOf(metaRt) + ")");
            }

            @Override
            protected RT toDownConverter(byte[] value) {
                return null;
            }

            @Override
            protected byte[] toUpConverter(LT value) {
                return null;
            }

            @Override
            protected Value<RT> toDownConverterValue(Value<byte[]> value) {
                if (!value.isData()) {
                    return (Value)RU.cast(value);
                }
                return value.map(v -> {
                    DataInOutStatic d = new DataInOutStatic(v);
                    Object dd = metaRt.deserialize(FastFutureContext.STUB, (DataIn)d);
                    if (d.isReadable()) {
                        throw new IllegalStateException();
                    }
                    return dd;
                });
            }

            @Override
            protected Value<byte[]> toUpConverterValue(Value<LT> value) {
                return value.map(dd -> {
                    if (dd == null) {
                        return null;
                    }
                    DataInOut d = new DataInOut();
                    metaLt.serialize(FastFutureContext.STUB, dd, (DataOut)d);
                    return d.toArray();
                });
            }
        };
        res.up().link((Gate)RU.cast((Object)this));
        return res.down();
    }

    public void unlink();

    public Gate<TRead, TWrite> link();

    public void link0(Gate<TRead, TWrite> var1);

    default public Gate<TWrite, TRead> buffer() {
        return BufferNode.of(this).up();
    }

    default public void insertBuffer() {
        FGate.OutSideGate old = (FGate.OutSideGate)this.link();
        FGate th = ((FGate.OutSideGate)this).getFGate();
        if (th.acceptor instanceof BufferNode.BGate) {
            return;
        }
        if (old != null && old.getFGate().acceptor instanceof BufferNode.BGate) {
            return;
        }
        BufferNode.of(this).up().link(old);
    }

    default public void linkFGate(FGate<TRead, TWrite> side) {
        this.link(side.outSide());
    }

    public void link(Gate<TRead, TWrite> var1);

    default public <TWrite2> Gate<TWrite, TWrite2> mapWrite(String name, AFunction<TRead, TWrite2> f1) {
        return this.map(name, f1, AFunction.stub());
    }

    default public <TRead2> Gate<TRead2, TRead> mapRead(String name, AFunction<TRead2, TWrite> f2) {
        return this.map(name, AFunction.stub(), f2);
    }

    default public <TWrite2> Gate<TWrite, TWrite2> mapAsyncWrite(String name, AFunction<TRead, ARFuture<TWrite2>> f1) {
        return this.mapAsync(name, f1, ARFuture::of);
    }

    default public <TRead2> Gate<TRead2, TRead> mapAsyncRead(String name, AFunction<TRead2, ARFuture<TWrite>> f2) {
        return this.mapAsync(name, ARFuture::of, f2);
    }

    default public <TWrite2, TRead2> Gate<TRead2, TWrite2> mapAsync(final String name, final AFunction<TRead, ARFuture<TWrite2>> f1, final AFunction<TRead2, ARFuture<TWrite>> f2) {
        NodeConverterAsync res = new NodeConverterAsync<TRead, TWrite, TRead2, TWrite2>(){

            public void toString(AString sb) {
                sb.add("mapAsync(").add(name).add(":").add((Object)f1).add(':').add((Object)f2).add(")");
            }

            @Override
            public String toString() {
                return this.toString2();
            }

            @Override
            protected ARFuture<TWrite2> toDownConverter(TRead value) {
                return (ARFuture)f1.apply(value);
            }

            @Override
            protected ARFuture<TWrite> toUpConverter(TRead2 value) {
                return (ARFuture)f2.apply(value);
            }
        };
        res.up().link(this);
        return res.down();
    }

    default public <TWrite2, TRead2> Gate<TRead2, TWrite2> map(final String name, final AFunction<TRead, TWrite2> f1, final AFunction<TRead2, TWrite> f2) {
        NodeConverter res = new NodeConverter<TRead2, TWrite2, TRead, TWrite>(){

            public void toString(AString sb) {
                Class<?> c1 = f1.getClass();
                Class<?> c2 = f2.getClass();
                sb.add("map(").add(name).add(":");
                String n = c1.getName();
                if (c1.isSynthetic()) {
                    sb.add(n.substring(0, n.indexOf("$")));
                } else {
                    sb.add(c1.getSimpleName());
                }
                sb.add(':');
                n = c2.getName();
                if (c2.isSynthetic()) {
                    sb.add(n.substring(0, n.indexOf("$")));
                } else {
                    sb.add(c2.getSimpleName());
                }
                sb.add(")");
            }

            @Override
            public String toString() {
                return this.toString2();
            }

            @Override
            protected TWrite toDownConverter(TRead2 value) {
                return f2.apply(value);
            }

            @Override
            protected TWrite2 toUpConverter(TRead value) {
                return f1.apply(value);
            }
        };
        res.down().link(this);
        return res.up();
    }

    default public Gate<TWrite, TRead> bufferAutoFlush() {
        BufferNodeAutoFlush n = new BufferNodeAutoFlush();
        n.down().link(this);
        return n.up();
    }

    default public GateI<TWrite> ofFunction(String name, AFunction<TRead, TWrite> acceptor) {
        return this.ofBiConsumer(name, (v, r) -> r.send(v.map(acceptor)));
    }

    default public GateI<TWrite> ofDataOut(String name, DataOut consumer) {
        return ((Gate)RU.cast((Object)this)).toConsumer(name, arg_0 -> ((DataOut)consumer).write(arg_0));
    }

    default public GateI<TWrite> ofFuture(String name, ARFuture<TRead> consumer) {
        return this.toConsumer(name, arg_0 -> consumer.tryDone(arg_0));
    }

    default public GateI<TWrite> ofSideTryFuture(String name, ARFuture<TRead> consumer) {
        return this.toConsumer(name, arg_0 -> consumer.tryDone(arg_0));
    }

    default public GateI<TWrite> toConsumer(String name, AConsumer<TRead> consumer) {
        FGate res = FGate.of(new OfConsumer(consumer, name));
        this.link(res.outSide());
        return res.inSide;
    }

    default public GateI<TWrite> toConsumerValue(String name, AConsumer<Value<TRead>> consumer) {
        FGate res = FGate.of(new OfConsumerValue(name, consumer));
        this.link(res.outSide());
        return res.inSide;
    }

    default public GateI<TWrite> ofBiConsumer(String name, ABiConsumer<Value<TRead>, GateI<TWrite>> consumer) {
        FGate<TWrite, TRead> res = FGate.of(new OfBiConsumer<TRead, TWrite>(name, consumer));
        this.link(res.outSide());
        return res.inSide;
    }

    default public GateI<TWrite> toAcceptor(final String name, final AcceptorI<TWrite, TRead> g) {
        FGate gg = FGate.of(new AcceptorI<TWrite, TRead>(){

            @Override
            public void send(FGate<TRead, TWrite> fGate, Value<TRead> value) {
                g.send(fGate, value);
            }

            @Override
            public void setFGate(FGate<TRead, TWrite> gg) {
                g.setFGate(gg);
            }

            public void toString(AString sb) {
                sb.add(name).add("(");
                g.toString(sb);
                sb.add(")");
            }

            public String toString2() {
                return g.toString2();
            }

            public <T> T find(Class<T> type) {
                return (T)g.find(type);
            }

            public Object[] getOwners() {
                return g.getOwners();
            }

            public <T> T find(CTypeI<T> type) {
                return (T)g.find(type);
            }
        });
        this.link(gg.outSide());
        return gg.inSide;
    }

    default public GateI<TWrite> ofCollection(String name, Queue<TRead> q) {
        return this.toConsumer(name, q::add);
    }

    default public Gate<TWrite, TRead> distinctWrite(String name) {
        ConcurrentHashSet oldData = new ConcurrentHashSet();
        return this.filter(name, APredicate.TRUE_STUB(), ((Set)oldData)::add);
    }

    default public Gate<TWrite, TRead> distinctRead(String name) {
        ConcurrentHashSet oldData = new ConcurrentHashSet();
        return this.filter(name, ((Set)oldData)::add, APredicate.TRUE_STUB());
    }

    default public Gate<TWrite, TRead> filter(String name, final APredicate<TRead> filterRead, final APredicate<TWrite> filterWrite) {
        NodeFilter n = new NodeFilter<TRead, TWrite>(name){

            @Override
            public void toString(AString sb) {
                sb.add("filter(").add((Object)filterRead).add(':').add((Object)filterWrite).add(")");
            }

            @Override
            protected boolean toDownFilter(TRead value) {
                return filterRead.test(value);
            }

            @Override
            protected boolean toUpFilter(TWrite value) {
                return filterWrite.test(value);
            }
        };
        this.link(n.up());
        return n.down();
    }

    default public Gate<TWrite, TRead> log(final String title, final String directLeft, final String directRight, final AConsumer<Value<TWrite>> directLeftFun, final AConsumer<Value<TRead>> directRightFun) {
        NodeConverter res = new NodeConverter<TWrite, TRead, TRead, TWrite>(){

            public void toString(AString sb) {
                sb.add("loggerWithFun(").add(title).add(")");
            }

            @Override
            public String toString() {
                return this.toString2();
            }

            @Override
            protected TWrite toDownConverter(TWrite value) {
                return value;
            }

            @Override
            protected TRead toUpConverter(TRead value) {
                return value;
            }

            private void printLog(String direction, Object val) {
                byte[] v;
                if (val == null) {
                    return;
                }
                if (val instanceof byte[] && (v = (byte[])val).length > 10) {
                    val = Arrays.copyOf(v, 10);
                }
                Log.debug((String)"stream log [$streamLogTitle] $direction <- $data", (Object[])new Object[]{"streamLogTitle", title, "direction", direction, "data", val});
            }

            @Override
            protected Value<TWrite> toDownConverterValue(Value<TWrite> value) {
                this.printLog(directLeft, value.data());
                directLeftFun.accept(value);
                return value;
            }

            @Override
            protected Value<TRead> toUpConverterValue(Value<TRead> value) {
                this.printLog(directRight, value.data());
                directRightFun.accept(value);
                return value;
            }
        };
        res.down().link(this);
        return res.up();
    }

    default public Gate<TWrite, TRead> log(final String title, final String directLeft, final String directRight) {
        NodeConverter res = new NodeConverter<TWrite, TRead, TRead, TWrite>(){

            public void toString(AString sb) {
                sb.add("logger(").add(title).add(")");
            }

            @Override
            public String toString() {
                return this.toString2();
            }

            private void printLog(String direction, Object val) {
                byte[] v;
                if (val == null) {
                    return;
                }
                if (val instanceof byte[] && (v = (byte[])val).length > 10) {
                    val = Arrays.copyOf(v, 10);
                }
                Log.debug((String)"stream log [$streamLogTitle] $direction <- $data", (Object[])new Object[]{"streamLogTitle", title, "direction", direction, "data", val});
            }

            @Override
            protected TWrite toDownConverter(TWrite value) {
                return value;
            }

            @Override
            protected TRead toUpConverter(TRead value) {
                return value;
            }

            @Override
            protected Value<TWrite> toDownConverterValue(Value<TWrite> value) {
                this.printLog(directLeft, value.data());
                return value;
            }

            @Override
            protected Value<TRead> toUpConverterValue(Value<TRead> value) {
                this.printLog(directRight, value.data());
                return value;
            }
        };
        res.down().link(this);
        return res.up();
    }
}

