/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.utils.RU;
import io.aether.utils.streams.FGate;
import io.aether.utils.streams.Node;
import io.aether.utils.streams.Value;
import org.jetbrains.annotations.NotNull;

public abstract class NodeConverter<TDown2, TUp2, TUp, TDown>
implements Node<TDown2, TUp2, TUp, TDown> {
    private final FGate<TDown2, TUp2> up = FGate.of(new FGate.Pair<TDown2, TUp2, TDown>(this){

        @Override
        public @NotNull FGate.InsideGate pair() {
            return NodeConverter.this.down.inSide;
        }

        @Override
        public void send(FGate<TDown2, TUp2> fGate, Value<TDown2> value) {
            if (value.isData()) {
                if (this.pair().fGate.outSide().link() == null) {
                    value.reject(this.pair());
                    return;
                }
                Value v = NodeConverter.this.toDownConverterValue(value);
                if (v != null) {
                    this.pair().send(v);
                }
            } else {
                this.pair().send((Value)RU.cast(value));
            }
        }
    });
    private final FGate<TUp, TDown> down = FGate.of(new FGate.Pair<TUp, TDown, TUp2>(this){

        @Override
        public @NotNull FGate.InsideGate pair() {
            return NodeConverter.this.up.inSide;
        }

        @Override
        public void send(FGate<TUp, TDown> fGate, Value<TUp> value) {
            if (this.pair().fGate.outSide().link() == null) {
                value.reject(this.pair());
                return;
            }
            if (value.isOnlyRequestData()) {
                this.pair().send((Value)RU.cast(value));
                return;
            }
            if (value.isData()) {
                Value v = NodeConverter.this.toUpConverterValue(value);
                if (v != null) {
                    this.pair().send(v);
                }
            } else if (value.isForce()) {
                this.pair().send((Value)RU.cast(value));
            }
        }
    });

    @Override
    public FGate<TDown2, TUp2> gUp() {
        return this.up;
    }

    @Override
    public FGate<TUp, TDown> gDown() {
        return this.down;
    }

    protected abstract TDown toDownConverter(TDown2 var1);

    protected abstract TUp2 toUpConverter(TUp var1);

    protected Value<TDown> toDownConverterValue(Value<TDown2> value) {
        return value.map(this::toDownConverter);
    }

    protected Value<TUp2> toUpConverterValue(Value<TUp> value) {
        return value.map(this::toUpConverter);
    }

    public String toString() {
        return "Node converter";
    }
}

