/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.utils.RU;
import io.aether.utils.futures.ARFuture;
import io.aether.utils.streams.FGate;
import io.aether.utils.streams.Node;
import io.aether.utils.streams.Value;
import org.jetbrains.annotations.NotNull;

public abstract class NodeConverterAsync<TDown2, TUp2, TUp, TDown>
implements Node<TDown2, TUp2, TUp, TDown> {
    private final FGate<TUp, TDown> down = FGate.of(new FGate.Pair<TUp, TDown, TUp2>(this){

        @Override
        public @NotNull FGate.InsideGate pair() {
            return NodeConverterAsync.this.up.inSide;
        }

        @Override
        public void send(FGate<TUp, TDown> fGate, Value<TUp> value) {
            if (value.data() == null) {
                this.pair().send((Value)RU.cast(value));
                return;
            }
            ARFuture res = NodeConverterAsync.this.toUpConverter(value.data());
            if (res == null) {
                value.success(this);
            } else {
                res.to(v -> {
                    if (v == null) {
                        value.success(this);
                    } else {
                        this.pair().send(value.map2(v));
                    }
                });
            }
        }
    });
    private final FGate<TDown2, TUp2> up = FGate.of(new FGate.Pair<TDown2, TUp2, TDown>(this){

        @Override
        public @NotNull FGate.InsideGate pair() {
            return NodeConverterAsync.this.down.inSide;
        }

        @Override
        public void send(FGate<TDown2, TUp2> fGate, Value<TDown2> value) {
            if (!value.isData()) {
                this.pair().send((Value)RU.cast(value));
                return;
            }
            ARFuture res = NodeConverterAsync.this.toDownConverter(value.data());
            if (res == null) {
                value.success(this);
            } else {
                res.to(v -> {
                    if (v == null) {
                        value.success(this);
                    } else {
                        this.pair().send(value.map2(v));
                    }
                });
            }
        }
    });

    protected abstract ARFuture<TDown> toDownConverter(TDown2 var1);

    protected abstract ARFuture<TUp2> toUpConverter(TUp var1);

    public String toString() {
        return "async converter";
    }

    @Override
    public FGate<TDown2, TUp2> gUp() {
        return this.up;
    }

    @Override
    public FGate<TUp, TDown> gDown() {
        return this.down;
    }
}

