/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.RU;
import io.aether.utils.ToString;
import io.aether.utils.WeakCollection;
import io.aether.utils.flow.Flow;
import io.aether.utils.interfaces.AConsumer;
import io.aether.utils.slots.EventConsumer;
import io.aether.utils.streams.AcceptorI;
import io.aether.utils.streams.BlockMgr;
import io.aether.utils.streams.FGate;
import io.aether.utils.streams.Gate;
import io.aether.utils.streams.GateI;
import io.aether.utils.streams.NodeUp;
import io.aether.utils.streams.Value;
import io.aether.utils.streams.ValueProxy;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class Switcher<TUp, TDown>
implements NodeUp<TUp, TDown> {
    private final WeakCollection<FGate<TDown, TUp>> ups = new WeakCollection();
    private final ConcurrentLinkedQueue<FGate<TDown, TUp>> upsHard = new ConcurrentLinkedQueue();
    private final EventConsumer<FGate<TDown, TUp>> onLink = new EventConsumer();
    private final EventConsumer<GateI<TUp>> onFirstSoftWritable = new EventConsumer();
    private final FGate<TUp, TDown> down = FGate.of(new AcceptorI<TDown, TUp>(){

        public void toString(AString sb) {
            sb.add((ToString)Switcher.this).add("(down)");
        }

        @Override
        public void send(FGate<TUp, TDown> fGate, Value<TUp> value) {
            Switcher.this.sendUp(value);
        }
    });
    public final BlockMgr blockMgrGlobal = new BlockMgr();

    public void onLink(AConsumer<FGate<TDown, TUp>> c) {
        this.onLink.add(c);
    }

    public void toString(AString sb) {
        sb.add("switcher(").add(this.ups.size()).add(":").add(this.upsHard.size()).add(")");
    }

    public String toString() {
        return this.toString2();
    }

    @Override
    public FGate<TUp, TDown> gDown() {
        return this.down;
    }

    public Gate<TDown, TUp> linkUp(Gate<TUp, TDown> up) {
        Gate<TDown, TUp> gInner = this.linkUp();
        gInner.link(up);
        return gInner;
    }

    public Gate<TDown, TUp> linkUp() {
        FGate gInner = FGate.of(new SplitterUpGateSoft());
        return gInner.outSide();
    }

    public Gate<TDown, TUp> linkUpHard(Gate<TUp, TDown> up) {
        Gate<TDown, TUp> gInner = this.linkUpHard();
        gInner.link(up);
        return gInner;
    }

    public Gate<TDown, TUp> linkUpHard() {
        FGate gInner = FGate.of(new SplitterUpGateHard());
        return gInner.outSide();
    }

    public void flushUp() {
        for (FGate<TDown, TUp> g : this.ups) {
            g.inSide.send(Value.ofForce());
        }
        for (FGate<TDown, TUp> g : this.upsHard) {
            g.inSide.send(Value.ofForce());
        }
    }

    protected void sendUp(final Value<TUp> value, final FGate<TDown, TUp> g, final AtomicInteger abortCounter, final AtomicBoolean finalFlag) {
        final SplitterUpGate sup = (SplitterUpGate)RU.cast(g.acceptor);
        abortCounter.incrementAndGet();
        g.inSide.send(new ValueProxy<TUp>(value){

            @Override
            public void success(Object owner) {
                if (finalFlag.compareAndSet(false, true)) {
                    value.success(owner);
                }
            }

            @Override
            public void reject(Object owner, long blockId) {
                if (sup.blockMgr.block(blockId)) {
                    if (abortCounter.decrementAndGet() == 0 && finalFlag.compareAndSet(false, true) && Switcher.this.blockMgrGlobal.block(blockId)) {
                        value.reject(Switcher.this, blockId);
                    }
                } else {
                    Switcher.this.sendUp(value, g, abortCounter, finalFlag);
                }
            }
        });
    }

    public void sendUp(Value<TUp> value) {
        value.enter(this);
        if (this.blockMgrGlobal.isBlocked()) {
            value.reject(this);
            return;
        }
        AtomicBoolean finalFlag = new AtomicBoolean();
        AtomicInteger abortCounter = new AtomicInteger(1);
        long bid = Value.BLOCK_COUNTER.incrementAndGet();
        VarHandle.fullFence();
        for (FGate g : Flow.flow(this.ups).addAll(this.upsHard)) {
            SplitterUpGate sup = (SplitterUpGate)RU.cast(g.acceptor);
            if (sup.blockMgr.isBlocked()) continue;
            this.sendUp(value, g, abortCounter, finalFlag);
        }
        if (abortCounter.decrementAndGet() == 0 && finalFlag.compareAndSet(false, true)) {
            if (this.blockMgrGlobal.block(bid)) {
                value.reject(this, this.blockMgrGlobal.get());
            } else {
                this.sendUp(value);
            }
        }
    }

    public boolean existsLinks() {
        return !this.ups.isEmpty() || !this.upsHard.isEmpty();
    }

    public void onFirstSoftWritable(AConsumer<GateI<TUp>> consumer) {
        this.onFirstSoftWritable.add(consumer);
    }

    protected void sendToDown(SplitterUpGate sup, FGate<TDown, TUp> fGate, Value<TDown> value) {
        value.enter(this);
        if (value.isClose()) {
            this.ups.remove(fGate);
            this.upsHard.remove(fGate);
            value = value.notClose();
        }
        if (value.isOnlyRequestData()) {
            if (sup.blockMgr.unblock(value.getRequestDataId())) {
                this.blockMgrGlobal.unblock(value.getRequestDataId());
                this.down.inSide.send(value);
                if (sup.firstRequestData.compareAndSet(false, true)) {
                    this.onLink.fire(fGate);
                    sup.onLink(fGate.link);
                }
            }
            return;
        }
        this.down.inSide.send(value);
    }

    public abstract class SplitterUpGate
    implements AcceptorI<TUp, TDown> {
        private final AtomicBoolean firstRequestData = new AtomicBoolean();
        volatile FGate<TDown, TUp> fGate;
        public final BlockMgr blockMgr = new BlockMgr();

        public String toString() {
            return this.toString2();
        }

        @Override
        public void setFGate(FGate<TDown, TUp> g) {
            this.fGate = g;
        }

        protected abstract void onLink(Gate<TUp, TDown> var1);

        @Override
        public void send(FGate<TDown, TUp> fGate, Value<TDown> value) {
            Switcher.this.sendToDown(this, fGate, value);
        }
    }

    public class SplitterUpGateSoft
    extends SplitterUpGate {
        @Override
        protected void onLink(Gate<TUp, TDown> g) {
            Switcher.this.ups.add((Object)this.fGate);
            Switcher.this.onLink.fire((Object)this.fGate);
        }

        public void toString(AString sb) {
            sb.add((ToString)Switcher.this).add("(soft)").add(" -> ").add((ToString)Switcher.this.down.inSide);
        }
    }

    public class SplitterUpGateHard
    extends SplitterUpGate {
        @Override
        protected void onLink(Gate<TUp, TDown> g) {
            Switcher.this.upsHard.add(this.fGate);
            Switcher.this.onLink.fire((Object)this.fGate);
        }

        public void toString(AString sb) {
            sb.add((ToString)Switcher.this).add("(hard)").add(" -> ").add((ToString)Switcher.this.down.inSide);
        }
    }
}

