/*
 * Decompiled with CFR 0.152.
 */
package io.aether.utils.streams;

import io.aether.utils.AString;
import io.aether.utils.interfaces.AFunction;
import io.aether.utils.streams.Value;

public class ValueMap<T2, T>
implements Value<T2> {
    private final Value<T> self;
    private final AFunction<T, T2> mapper;
    volatile T2 cacheData;

    public ValueMap(Value<T> self, AFunction<T, T2> mapper) {
        this.self = self;
        this.mapper = mapper;
    }

    public String toString() {
        return this.toString2();
    }

    public void toString(AString sb) {
        sb.add("value(").add(this.data()).add(")");
    }

    @Override
    public void enter(Object owner) {
        this.self.enter(owner);
    }

    @Override
    public boolean isData() {
        return this.self.isData();
    }

    @Override
    public boolean isRequestData() {
        return this.self.isRequestData();
    }

    @Override
    public T2 data() {
        if (this.isData()) {
            if (this.cacheData == null) {
                this.cacheData = this.mapper.apply(this.self.data());
            }
            return this.cacheData;
        }
        return null;
    }

    @Override
    public void reject(Object owner, long blockId) {
        this.self.reject(owner);
    }

    @Override
    public int priority() {
        return this.self.priority();
    }

    @Override
    public boolean isClose() {
        return this.self.isClose();
    }

    @Override
    public boolean isForce() {
        return this.self.isForce();
    }

    @Override
    public void success(Object owner) {
        this.self.success(owner);
    }
}

