package io.aether.api.common;


import io.aether.crypto.CryptoProviderFactory;

public interface SignUtil {
    byte[] getData();

    static io.aether.crypto.Sign of(Sign sign) {
        if (sign instanceof SignAE_ED25519) {
            return CryptoProviderFactory.getProvider("SODIUM").createSign(sign.getData());
        } else if (sign instanceof SignHYDROGEN) {
            return CryptoProviderFactory.getProvider("HYDROGEN").createSign(sign.getData());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    static Sign of(io.aether.crypto.Sign sign) {
        switch (sign.getProviderName().toLowerCase()){
            case "sodium":
                return new SignAE_ED25519(sign.getSignData());
            case "hydrogen":
                return new SignHYDROGEN(sign.getSignData());
        }
        throw new UnsupportedOperationException();
    }
}
