package io.aether.common.expressions;

import io.aether.utils.CTypeI;

public final class And extends BinOperator {
	{
		type = CTypeI.BOOLEAN;
		typeRaw = boolean.class;
	}

	@Override
	protected void prepareForContext0() {
		calculate = new Calculate() {
			@Override
			public Object calc() {
				return calcBoolean();
			}
			@Override
			public boolean calcBoolean() {
				var v1 = left.calculate.calcBoolean();
				var v2 = right.calculate.calcBoolean();
				return v1 && v2;
			}
			@Override
			public byte calcByte() {
				return calcBoolean() ? (byte) 1 : 0;
			}
			@Override
			public short calcShort() {
				return calcBoolean() ? (short) 1 : 0;
			}
			@Override
			public int calcInt() {
				return calcBoolean() ? 1 : 0;
			}
			@Override
			public long calcLong() {
				return calcBoolean() ? 1 : 0;
			}
			@Override
			public double calcDouble() {
				return calcBoolean() ? 1 : 0;
			}
			@Override
			public float calcFloat() {
				return calcBoolean() ? 1 : 0;
			}
		};
	}
}