package io.aether.common.expressions;

import io.aether.net.fastMeta.Sealed;

@Sealed({Add.class, And.class, Div.class, Gt.class, Gte.class, Lt.class, Lte.class, Mul.class, Or.class, Sub.class})
public abstract class BinOperator extends Expression  {
	protected Expression left;
	protected Expression right;
	public Expression getLeft() {
		return left;
	}
	public void setLeft(Expression left) {
		children.remove(this.left);
		this.left = left;
		children.add(left);
	}

	public BinOperator() {
	}

	public BinOperator(Expression left, Expression right) {
		this.left = left;
		this.right = right;
	}

	public Expression getRight() {
		return right;
	}
	public void setRight(Expression right) {
		children.remove(this.right);
		this.right = right;
		children.add(right);
	}
}
