package io.aether.common.expressions;

import io.aether.net.fastMeta.Sealed;
import io.aether.utils.CTypeI;
import io.aether.utils.RU;
import io.aether.utils.flow.Flow;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Sealed({BinOperator.class, Invoke.class, LiteralArrayBoolean.class, LiteralArrayInt16.class, LiteralArrayInt32.class, LiteralArrayInt64.class, LiteralArrayInt8.class, LiteralBoolean.class, LiteralInt16.class, LiteralInt32.class, LiteralInt64.class, LiteralInt8.class, Not.class, Variable.class})
public abstract class Expression {
    protected final static Set<CTypeI<Number>> NUMBER_TYPES = RU.cast(Flow.flowArray(byte.class, short.class, int.class, long.class, float.class, double.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class)
            .map(CTypeI::of).toSet());
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    final transient List<Expression> children = new ArrayList<>();
    public transient CTypeI<?> type;
    public transient Class<?> typeRaw;
    public transient Calculate calculate;
    protected transient Ctx ctx;

    public Ctx getCtx() {
        return ctx;
    }

    protected abstract void prepareForContext0();

    public void prepareForContext(Ctx ctx) {
        this.ctx = ctx;
        prepareForContext0();
        for (var c : children) {
            c.prepareForContext(ctx);
        }
    }
}
