package io.aether.common.expressions;

import io.aether.net.fastMeta.AetherException;
import io.aether.net.exceptions.ErrorId;
import io.aether.utils.CTypeI;

public final class Gt extends BinOperator {
	{
		type = CTypeI.BOOLEAN;
		typeRaw = boolean.class;
	}

	@Override
	protected void prepareForContext0() {
		var t1 = left.type;
		var t2 = right.type;
		if (!NUMBER_TYPES.contains(t1) && t1 != CTypeI.STRING) throw new AetherException( "Bad type argument for operation DIV");
		if (!NUMBER_TYPES.contains(t2) && t2 != CTypeI.STRING) throw new AetherException( "Bad type argument for operation DIV");
		if (t1 == CTypeI.STRING || t2 == CTypeI.STRING) {
			calculate = new Calculate() {
				@Override
				public Object calc() {
					return calcBoolean();
				}
				@Override
				public boolean calcBoolean() {
					var v1 = String.valueOf(left.calculate.calc());
					var v2 = String.valueOf(right.calculate.calc());
					return v1.compareTo(v2) > 0;
				}
				@Override
				public byte calcByte() {
					return calcBoolean() ? (byte) 1 : 0;
				}
				@Override
				public short calcShort() {
					return calcBoolean() ? (short) 1 : 0;
				}
				@Override
				public int calcInt() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public long calcLong() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public double calcDouble() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public float calcFloat() {
					return calcBoolean() ? 1 : 0;
				}
			};
		} else if (t1 == CTypeI.DOUBLE || t1 == CTypeI.FLOAT ||
                   t2 == CTypeI.DOUBLE || t2 == CTypeI.FLOAT) {
			calculate = new Calculate() {
				@Override
				public Object calc() {
					return calcBoolean();
				}
				@Override
				public boolean calcBoolean() {
					var v1 = left.calculate.calcDouble();
					var v2 = right.calculate.calcDouble();
					return v1 > v2;
				}
				@Override
				public byte calcByte() {
					return calcBoolean() ? (byte) 1 : 0;
				}
				@Override
				public short calcShort() {
					return calcBoolean() ? (short) 1 : 0;
				}
				@Override
				public int calcInt() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public long calcLong() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public double calcDouble() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public float calcFloat() {
					return calcBoolean() ? 1 : 0;
				}
			};
		} else if (t1 == CTypeI.LONG || t2 == CTypeI.LONG) {
			calculate = new Calculate() {
				@Override
				public Object calc() {
					return calcBoolean();
				}
				@Override
				public boolean calcBoolean() {
					var v1 = left.calculate.calcLong();
					var v2 = right.calculate.calcLong();
					return v1 > v2;
				}
				@Override
				public byte calcByte() {
					return calcBoolean() ? (byte) 1 : 0;
				}
				@Override
				public short calcShort() {
					return calcBoolean() ? (short) 1 : 0;
				}
				@Override
				public int calcInt() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public long calcLong() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public double calcDouble() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public float calcFloat() {
					return calcBoolean() ? 1 : 0;
				}
			};
		} else {
			calculate = new Calculate() {
				@Override
				public Object calc() {
					return calcBoolean();
				}
				@Override
				public boolean calcBoolean() {
					var v1 = left.calculate.calcInt();
					var v2 = right.calculate.calcInt();
					return v1 > v2;
				}
				@Override
				public byte calcByte() {
					return calcBoolean() ? (byte) 1 : 0;
				}
				@Override
				public short calcShort() {
					return calcBoolean() ? (short) 1 : 0;
				}
				@Override
				public int calcInt() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public long calcLong() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public double calcDouble() {
					return calcBoolean() ? 1 : 0;
				}
				@Override
				public float calcFloat() {
					return calcBoolean() ? 1 : 0;
				}
			};
		}
	}
}
