package io.aether.common.expressions;

import io.aether.net.fastMeta.AetherException;
import io.aether.net.exceptions.ErrorId;
import io.aether.utils.RU;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.List;

public final class Invoke extends Expression {
    byte cmdId;
    List<Expression> arguments;
    transient MethodHandle methodHandle;
    transient Method method;

    @Override
    protected void prepareForContext0() {
        method = ctx.methods[cmdId];
        methodHandle = ctx.methodHandles[cmdId];
        if (!method.isVarArgs()) {
            if (arguments.size() != method.getParameterCount()) {
                throw new AetherException("Different argument count");
            }
        }
        var t = method.getReturnType();
        if (t.isPrimitive()) {
            if (t == byte.class) {
                calculate = new Calculate() {
                    @Override
                    public Object calc() {
                        return calcByte();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return calcByte() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        Object[] args = new Object[arguments.size()];
                        for (int i = 0; i < args.length; i++) {
                            args[i] = arguments.get(i).calculate.calc();
                        }
                        try {
                            return (byte) methodHandle.invokeWithArguments(args);
                        } catch (Throwable e) {
                           return RU.error(e);
                        }
                    }

                    @Override
                    public short calcShort() {
                        return calcByte();
                    }

                    @Override
                    public int calcInt() {
                        return calcByte();
                    }

                    @Override
                    public long calcLong() {
                        return calcByte();
                    }

                    @Override
                    public double calcDouble() {
                        return calcByte();
                    }

                    @Override
                    public float calcFloat() {
                        return calcByte();
                    }
                };
            } else if (t == short.class) {
                calculate = new Calculate() {
                    @Override
                    public Object calc() {
                        return calcShort();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return calcShort() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte) calcShort();
                    }

                    @Override
                    public short calcShort() {
                        Object[] args = new Object[arguments.size()];
                        for (int i = 0; i < args.length; i++) {
                            args[i] = arguments.get(i).calculate.calc();
                        }
                        try {
                            return (short) methodHandle.invokeWithArguments(args);
                        } catch (Throwable e) {
                           return RU.error(e);
                        }
                    }

                    @Override
                    public int calcInt() {
                        return calcShort();
                    }

                    @Override
                    public long calcLong() {
                        return calcShort();
                    }

                    @Override
                    public double calcDouble() {
                        return calcShort();
                    }

                    @Override
                    public float calcFloat() {
                        return calcShort();
                    }
                };
            } else if (t == int.class) {
                calculate = new Calculate() {
                    @Override
                    public Object calc() {
                        return calcInt();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return calcInt() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte) calcInt();
                    }

                    @Override
                    public short calcShort() {
                        return (short) calcInt();
                    }

                    @Override
                    public int calcInt() {
                        Object[] args = new Object[arguments.size()];
                        for (int i = 0; i < args.length; i++) {
                            args[i] = arguments.get(i).calculate.calc();
                        }
                        try {
                            return (int) methodHandle.invokeWithArguments(args);
                        } catch (Throwable e) {
                           return RU.error(e);
                        }
                    }

                    @Override
                    public long calcLong() {
                        return calcInt();
                    }

                    @Override
                    public double calcDouble() {
                        return calcInt();
                    }

                    @Override
                    public float calcFloat() {
                        return calcInt();
                    }
                };
            } else if (t == long.class) {
                calculate = new Calculate() {
                    @Override
                    public Object calc() {
                        return calcLong();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return calcLong() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte) calcLong();
                    }

                    @Override
                    public short calcShort() {
                        return (short) calcLong();
                    }

                    @Override
                    public int calcInt() {
                        return (int) calcLong();
                    }

                    @Override
                    public long calcLong() {
                        Object[] args = new Object[arguments.size()];
                        for (int i = 0; i < args.length; i++) {
                            args[i] = arguments.get(i).calculate.calc();
                        }
                        try {
                            return (long) methodHandle.invokeWithArguments(args);
                        } catch (Throwable e) {
                           return RU.error(e);
                        }
                    }

                    @Override
                    public double calcDouble() {
                        return calcLong();
                    }

                    @Override
                    public float calcFloat() {
                        return calcLong();
                    }
                };
            } else if (t == float.class) {
                calculate = new Calculate() {
                    @Override
                    public Object calc() {
                        return calcFloat();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return calcFloat() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte) calcFloat();
                    }

                    @Override
                    public short calcShort() {
                        return (short) calcFloat();
                    }

                    @Override
                    public int calcInt() {
                        return (int) calcFloat();
                    }

                    @Override
                    public long calcLong() {
                        return (long) calcFloat();
                    }

                    @Override
                    public double calcDouble() {
                        return calcFloat();
                    }

                    @Override
                    public float calcFloat() {
                        Object[] args = new Object[arguments.size()];
                        for (int i = 0; i < args.length; i++) {
                            args[i] = arguments.get(i).calculate.calc();
                        }
                        try {
                            return (float) methodHandle.invokeWithArguments(args);
                        } catch (Throwable e) {
                           return RU.error(e);
                        }
                    }
                };
            } else if (t == double.class) {
                calculate = new Calculate() {
                    @Override
                    public Object calc() {
                        return calcDouble();
                    }

                    @Override
                    public boolean calcBoolean() {
                        return calcDouble() != 0;
                    }

                    @Override
                    public byte calcByte() {
                        return (byte) calcDouble();
                    }

                    @Override
                    public short calcShort() {
                        return (short) calcDouble();
                    }

                    @Override
                    public int calcInt() {
                        return (int) calcDouble();
                    }

                    @Override
                    public long calcLong() {
                        return (long) calcDouble();
                    }

                    @Override
                    public double calcDouble() {
                        Object[] args = new Object[arguments.size()];
                        for (int i = 0; i < args.length; i++) {
                            args[i] = arguments.get(i).calculate.calc();
                        }
                        try {
                            return (double) methodHandle.invokeWithArguments(args);
                        } catch (Throwable e) {
                           return RU.error(e);
                        }
                    }

                    @Override
                    public float calcFloat() {
                        return (float) calcDouble();
                    }
                };
            }
        } else {
            calculate = new Calculate() {
                @Override
                public Object calc() {
                    Object[] args = new Object[arguments.size()];
                    for (int i = 0; i < args.length; i++) {
                        args[i] = arguments.get(i).calculate.calc();
                    }
                    try {
                        return methodHandle.invokeWithArguments(args);
                    } catch (Throwable e) {
                       return RU.error(e);
                    }
                }

                @Override
                public boolean calcBoolean() {
                    var o = calc();
                    if (o instanceof Boolean) {
                        return (boolean) o;
                    }
                    if (o instanceof Number) {
                        return ((Number) o).intValue() != 0;
                    }
                    if (o instanceof String) {
                        return Boolean.parseBoolean((String) o);
                    }
                    return o != null;
                }

                @Override
                public byte calcByte() {
                    var o = calc();
                    if (o instanceof Number) {
                        return ((Number) o).byteValue();
                    }
                    if (o instanceof String) {
                        return Byte.parseByte((String) o);
                    }
                    return 0;
                }

                @Override
                public short calcShort() {
                    var o = calc();
                    if (o instanceof Number) {
                        return ((Number) o).shortValue();
                    }
                    if (o instanceof String) {
                        return Short.parseShort((String) o);
                    }
                    return 0;
                }

                @Override
                public int calcInt() {
                    var o = calc();
                    if (o instanceof Number) {
                        return ((Number) o).intValue();
                    }
                    if (o instanceof String) {
                        return Integer.parseInt((String) o);
                    }
                    return 0;
                }

                @Override
                public long calcLong() {
                    var o = calc();
                    if (o instanceof Number) {
                        return ((Number) o).longValue();
                    }
                    if (o instanceof String) {
                        return Long.parseLong((String) o);
                    }
                    return 0;
                }

                @Override
                public double calcDouble() {
                    var o = calc();
                    if (o instanceof Number) {
                        return ((Number) o).doubleValue();
                    }
                    if (o instanceof String) {
                        return Double.parseDouble((String) o);
                    }
                    return 0;
                }

                @Override
                public float calcFloat() {
                    var o = calc();
                    if (o instanceof Number) {
                        return ((Number) o).floatValue();
                    }
                    if (o instanceof String) {
                        return Float.parseFloat((String) o);
                    }
                    return 0;
                }
            };
        }
    }
}
