package io.aether.common.expressions;

import io.aether.utils.CTypeI;

public final class LiteralArrayBoolean extends Expression {
	public boolean[] value;
	@Override
	protected void prepareForContext0() {
		typeRaw = boolean[].class;
		type = CTypeI.BOOLEAN_ARR;
		calculate = new Calculate() {
			@Override
			public Object calc() {
				return value;
			}
			@Override
			public boolean calcBoolean() {
				return value != null;
			}
			@Override
			public byte calcByte() {
				return (byte) value.length;
			}
			@Override
			public short calcShort() {
				return (short) value.length;
			}
			@Override
			public int calcInt() {
				return value.length;
			}
			@Override
			public long calcLong() {
				return value.length;
			}
			@Override
			public double calcDouble() {
				return value.length;
			}
			@Override
			public float calcFloat() {
				return value.length;
			}
		};
	}
}
