package io.aether.common.expressions;

import io.aether.utils.CTypeI;

public final class LiteralBoolean extends Expression {
	public boolean value;
	@Override
	protected void prepareForContext0() {
		type = CTypeI.BOOLEAN;
		typeRaw = boolean.class;
		byte valueByte = value ? (byte) 1 : 0;
		boolean valueBoolean = value;
		Object valueObject = value;
		calculate = new Calculate() {
			@Override
			public Object calc() {
				return valueObject;
			}
			@Override
			public boolean calcBoolean() {
				return valueBoolean;
			}
			@Override
			public byte calcByte() {
				return valueByte;
			}
			@Override
			public short calcShort() {
				return valueByte;
			}
			@Override
			public int calcInt() {
				return valueByte;
			}
			@Override
			public long calcLong() {
				return valueByte;
			}
			@Override
			public double calcDouble() {
				return valueByte;
			}
			@Override
			public float calcFloat() {
				return valueByte;
			}
		};
	}
}
