package io.aether.common.expressions;

import io.aether.utils.CTypeI;

import java.lang.invoke.MethodHandles;

public final class LiteralInt32 extends Expression {
	public static final CTypeI<?> CTYPE = CTypeI.of(MethodHandles.lookup().lookupClass());
	public int value;
	public LiteralInt32(int value) {
		this.value = value;
	}
	public LiteralInt32() {
	}
	@Override
	protected void prepareForContext0() {
		type = CTypeI.INT;
		typeRaw = int.class;
		byte valueByte = (byte) value;
		short valueShort = (short) value;
		int valueInt = value;
		long valueLong = value;
		float valueFloat = value;
		double valueDouble = value;
		boolean valueBoolean = value != 0;
		Object valueObject = value;
		calculate = new Calculate() {
			@Override
			public Object calc() {
				return valueObject;
			}
			@Override
			public boolean calcBoolean() {
				return valueBoolean;
			}
			@Override
			public byte calcByte() {
				return valueByte;
			}
			@Override
			public short calcShort() {
				return valueShort;
			}
			@Override
			public int calcInt() {
				return valueInt;
			}
			@Override
			public long calcLong() {
				return valueLong;
			}
			@Override
			public double calcDouble() {
				return valueDouble;
			}
			@Override
			public float calcFloat() {
				return valueFloat;
			}
		};
	}
}
