package io.aether.crypto;

public class PairAsymKeys implements PairKeys {
    public final AKey.AsymmetricPublic publicKey;
    public final AKey.AsymmetricPrivate privateKey;

    @Override
    public String getProviderName() {
        return publicKey.getProviderName();
    }

    @Override
    public CryptoProvider getCryptoProvider() {
        return publicKey.getCryptoProvider();
    }

    public PairAsymKeys(AKey.AsymmetricPublic publicKey, AKey.AsymmetricPrivate privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public AKey.AsymmetricPrivate getPrivateKey() {
        return privateKey;
    }

    public AKey.AsymmetricPublic getPublicKey() {
        return publicKey;
    }
}