package io.aether.crypto;

public interface PairKeys extends CryptoProviderUnit {
    AKey getPrivateKey();

    AKey getPublicKey();

    default CryptoEngine toCryptoEngine() {
        var pk = getPublicKey();
        if (pk.getKeyType() != KeyType.ASYMMETRIC_PUBLIC) {
            throw new IllegalStateException();
        }
        return getCryptoProvider().createAsymmetricEngine((AKey.AsymmetricPrivate) getPrivateKey(), (AKey.AsymmetricPublic) getPublicKey());

    }
}