package io.aether.crypto;

public class PairSignKeys implements PairKeys{
    public final AKey.SignPublic publicKey;
    public final AKey.SignPrivate privateKey;
    public Signer toSigner(){
        return getCryptoProvider().createSigner(this);
    }
    @Override
    public String getProviderName() {
        return publicKey.getProviderName();
    }

    @Override
    public CryptoProvider getCryptoProvider() {
        return publicKey.getCryptoProvider();
    }

    public PairSignKeys(AKey.SignPublic publicKey, AKey.SignPrivate privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public AKey.SignPublic getPublicKey() {
        return publicKey;
    }

    public AKey.SignPrivate getPrivateKey() {
        return privateKey;
    }
}