package io.aether.crypto;

public interface Signer extends SignChecker {
    /**
     * Signs the provided data using a private key.
     * @param data The data to be signed.
     * @return The resulting Sign object.
     */
    Sign sign(byte[] data);
    default Sign sign(AKey key){
        return sign(key.getData());
    }
}
